/* mbed Stepper Library
 * Copyright (c) 2010 fachatz
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include "stepper.h"
#include "mbed.h"

 // define the Stepper Motor save start/stop speed 
#define START_STOP_SPEED 500

// define Library version number
#define VERSION 0.3

// led4, used for testing the direction signal

stepper::stepper(PinName clk, PinName dir) : _clk(clk), _dir(dir), s_thread(osPriorityNormal) {
    _clk = 0, _dir = 0;
    s_thread.start(this, &stepper::run);
}

void stepper::step(int n_steps, bool direction, int speed, bool accel) {
    if(accel) s_accelspeed = START_STOP_SPEED;
    else s_accelspeed = speed;
    s_speed = speed;
    s_direction = direction;
    s_accel = accel;
    s_n_steps = n_steps;
    
}
void stepper::run() {
    printf("stepper thread running");
    while (true) {
        if (s_n_steps != 0){
            for(int i=0; i<s_n_steps; i++) 
            {
                if(s_accel)//linear acceleration
                {
                    if(i < START_STOP_SPEED) if (--s_accelspeed == s_speed) s_accelspeed ++; 
                    if(i > (s_n_steps-START_STOP_SPEED)) if(++s_accelspeed == START_STOP_SPEED) s_accelspeed--;
                }  
                _dir =  s_direction;
                _clk = 1;
                wait_us(1);
                _clk = 0;
                wait_us(1);
                wait_us(s_accelspeed);
            }
            s_n_steps = 0;
        }
        
        
        ThisThread::sleep_for(10);
    }
    
}

// version() returns the version number of the library
float stepper::version(void) {
    return VERSION;    
}
