#include "mbed.h"
typedef struct {
    int value;
} message_t;
const int size = 8;
MemoryPool<message_t, size> mpool;
Queue<message_t, size> queue;
Thread thread1;
Thread thread2;
Mutex mutex;
ConditionVariable cond(mutex);
int numberOfElement = 0;

void produce() {
    while(true) {
        wait(rand()%5);
        int value = rand();
        mutex.lock();
        while(numberOfElement == size) {
            printf("queue is full");
            cond.wait();
        }  
        message_t *message = mpool.alloc();
        message->value = value;
        queue.put(message);
        numberOfElement++;
        printf("\nPut Message: %d\n\r"   , message->value);
        cond.notify_all();
        mutex.unlock();
    }
}

void consume() {
    while(true) {
        wait(rand()%5);
        mutex.lock();
        while(numberOfElement == 0) {
            printf("queue is empty");
            cond.wait();
        }
        osEvent evt = queue.get();
        numberOfElement--;
        if (evt.status == osEventMessage) {
            message_t *message = (message_t*)evt.value.p;
            printf("\nConsumed Message: %d\n\r"   , message->value);
            mpool.free(message);
        }
        cond.notify_all();
        mutex.unlock();
        
    }
}
int main() {
    thread1.start(callback(produce));
    thread2.start(callback(consume));
    thread1.join();
    thread2.join();
}