#include "mbed.h"


DigitalOut led2(LED2);
DigitalOut led3(LED3);

// Blink function toggles the led in a long running loop
void blink_led(DigitalOut *led) {
    *led = !*led;
    wait(1);
    *led = !*led;
}



// Spawns a thread to run blink for 5 seconds
int main() {
    while(1) {
        Thread thread1;
        Thread thread2;
        thread1.start(callback(blink_led, &led2));
        thread1.join();
        thread2.start(callback(blink_led, &led3));
        thread2.join();
    }
}