#include "mbed.h"
#include "stm32l475e_iot01_accelero.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

void blink_led(int led1On, int led2On, int led3On, int reset, DigitalOut led = LED4) {
    led1 = led1On;
    led2 = led2On;
    led3 = led3On;
    wait(1);
    if(reset) {
        led1 = 0;    
        led2 = 0;
        led3 = 0;
    } else {
        led = !led;
    }
}

int main()
{
    int16_t pDataXYZ[3] = {0};

    BSP_ACCELERO_Init();
        
    while(1) {
        BSP_ACCELERO_AccGetXYZ(pDataXYZ);
        printf("\nACCELERO_X = %d\n", pDataXYZ[0]);
        printf("ACCELERO_Y = %d\n", pDataXYZ[1]);
        printf("ACCELERO_Z = %d\n", pDataXYZ[2]);
        
        if(pDataXYZ[2] > 900 || pDataXYZ[2] < -900) { //Horizontal State
            blink_led(1, 0, 0, 0, led1);
        } else if(pDataXYZ[1] > 900 || pDataXYZ[1] < -900) { //Long Edge State
            blink_led(0, 1, 0, 0, led2);
        } else if(pDataXYZ[0] > 900 || pDataXYZ[0] < -900) { // Short Edge State
            blink_led(0, 0, 1, 0, led3);
        } else { // all other positions
            blink_led(1, 1, 1, 1);
        }
    }
}