#include "mbed.h"

DigitalOut led3(LED3);
InterruptIn button(USER_BUTTON);
EventQueue queue(32 * EVENTS_EVENT_SIZE);
Thread t;
int counter = 0;
volatile time_t seconds_now;

void rise_handler_thread_context(void) {
    counter++;
    if(counter == 2) {
        counter = 0;
        if((time(NULL) - seconds_now) < 2) {
                led3 = !led3;
                wait(0.8);
                led3 = !led3;
            }
    } else {
        seconds_now = time(NULL);
    }
}

void rise_handler_iterrupt_context(void) {
    // Execute the time critical part first
    // The rest can execute later in user context (and can contain code that's not interrupt safe)
    // We use the 'queue.call' function to add an event (the call to 'rise_handler_user_context') to the queue
    queue.call(rise_handler_thread_context);
}

void fall_handler(void) {
    printf("Output a String\n");
}

int main() {
    // Start the event queue
    t.start(callback(&queue, &EventQueue::dispatch_forever));
    printf("Starting in context %p\r\n", Thread::gettid());
    // The 'rise' handler will execute in IRQ context
    button.rise(rise_handler_iterrupt_context);
    // The 'fall' handler will execute in the context of thread 't'
    button.fall(queue.event(fall_handler));
}
