#include "decoder.h"



/**
* @brief    constructor
* @details  initializes interrupt on channel A, and initialises internal variables
* @param    NA
* @return   NA
* @warning  interrupt functionallity on channel B is not used as it is not required.
* 
*/

decoder :: decoder(PinName channelA, PinName channelB):_channelA(channelA),_channelB(channelB) {
    
    _channelA.rise(this, &decoder::isr);   
   
    _count = 0;
    _direction = 0;  
    
    _lowerLimit = 0;
    _upperLimit = 1; // set as default function must be called to change these values 
    
}

/**
* @brief    isr
* @details  interrupt servive routine to decode the encoder output
* @param    NA
* @return   NA
* @warning  
* 
*/



void decoder :: isr(){
    //confirmed as x1 decoding y analysing waveform
    
    uint8_t chA = _channelA.read();
    
    uint8_t chB = _channelB.read();
    
    if(chA == 1){
        
        if(chB == 1){
        
           if( _count != _upperLimit){
              _count++;               
            }
            _direction = 1;
            
            //pc.printf(" 1  %d\n\n",_count);//debug
                      
        }
        
        
        
        if(chB == 0){
            
            if(_count != _lowerLimit){
              _count--;  
            }
            _direction = 0;
            
            //pc.printf(" 0  %d\n\n",_count);//debug
            
        } 
        
    }   
            
}

/**
* @brief    getDirection()
* @details  function to return the class private variable _direction
* @param    NA
* @return   the direction of encoder
* @warning  
* 
*/

int8_t decoder :: getDirection(){
    
    return _direction;
    
    
    
}

/**
* @brief    getCount
* @details  function to return the class private variable _count
* @param    NA
* @return   the number of turns of encoder +/-
* @warning  
* 
*/

int16_t decoder :: getCount(){
    
    
    return _count;
    
}

/**
* @brief    setLimits()
* @details  sets the limits of the encoder counting
* @param    lower limit and upper limit
* @return   
* @warning  set to 0 and 1 by default by constructor user must change as required
* 
*/



void decoder :: setLimits(int8_t lower, int8_t upper){
    
    _lowerLimit = lower;
    _upperLimit = upper;
    
    
}

/**
* @brief    reset()
* @details  function to reset all internal counting and directional variables
* @param    NA
* @return   
* @warning  
* 
*/

void decoder :: reset(){
    
    
    _count = 0;
    _direction = 0; 
       
}

