#include "mbed.h"

#include "main.h"

#include <stdint.h>

#include "binwire.h"
#include "bitbang.h"
#include "util.h"

Serial debug(USBTX, USBRX);
SerialBuffered bp(4096, p13, p14);

struct _bp_config bp_config;
struct _mode_config mode_config;

DigitalInOut bp_mosi(p5);
DigitalInOut bp_miso(p6);
DigitalInOut bp_clk(p7);
DigitalInOut bp_cs(p8);
DigitalInOut bp_aux(p9);
DigitalInOut bp_adc(p15);

unsigned char mode = BUSPIRATE_MODE;

static void buspirate_handler()
{
    bool done = false;
    int c;
    int count = 0;

    while (!done) {
        c = bp.getc();
        if (c == 0x00) {
            if (++count >= 20) {
                // Enter bitbang mode
                mode = BITBANG_MODE;
                done = true;
            }
        } else {
            debug.printf("unsupported command: %x\n", c);
            count = 0;
        }
    }
}

static void bitbang_handler()
{
    bool done = false;
    int c = 0x00;

    while (1) {
        switch (c) {
        case 0x00:
            bp.printf("BBIO1");
            break;
        case 0x0F:
            // Exit bitbang mode
            mode = BUSPIRATE_MODE;
            done = true;
            break;
        case 0x05:
            // Enter RAW wire mode
            mode = RAW_WIRE_MODE;
            done = true;
            break;
        default:
            debug.printf("unsupported bitbang command: %x\n", c);
            break;
        }
        if (done)
            break;
        c = bp.getc();
    }
}

int main()
{
    debug.baud(115200);
    bp.baud(9600);

    debug.printf("mbedPirate started\n");

    while (1) {
        switch (mode) {
        case BUSPIRATE_MODE:
            debug.printf("enter buspirate mode\n");
            buspirate_handler();
            break;
        case BITBANG_MODE:
            debug.printf("enter bitbang mode\n");
            bitbang_handler();
            break;
        case RAW_WIRE_MODE:
            debug.printf("enter rawwire mode\n");
            bin_wire_handler();
            break;
        default:
            debug.printf("unsupported mode: %d\n", mode);
            break;
        }
    }
}
