#ifndef MAIN_H
#define MAIN_H

#include "SerialBuffered.h"

enum {
    BUSPIRATE_MODE = 0,
    BITBANG_MODE,
    RAW_WIRE_MODE,
};

struct _bp_config {
    unsigned char terminal_input[4096];
};

struct _mode_config {
    unsigned char speed; 
    unsigned char numbits;
    unsigned char buf[16];
    unsigned char altAUX:1;
    unsigned char periodicService:1;
    unsigned char lsbEN:1;
    unsigned char HiZ:1;
    unsigned char int16:1;
};

extern Serial debug;
extern SerialBuffered bp;

extern struct _bp_config bp_config;
extern struct _mode_config mode_config;

extern DigitalInOut bp_mosi;
extern DigitalInOut bp_miso;
extern DigitalInOut bp_clk;
extern DigitalInOut bp_cs;
extern DigitalInOut bp_aux;
extern DigitalInOut bp_adc;

extern unsigned char mode;

#endif
