#include "mbed.h"

BusOut leds( LED4, LED3, LED2, LED1 );
char count;

InterruptIn button( p16 );   //  interrupt instance for the button
Timer t;               //  To manage debounce by menchanical switch

#define DEBOUNCING_INTERVAL 20   //  Debouncing interval (in mili-seconds)

void isr_buton( void ) {
    if ( t.read_ms() > DEBOUNCING_INTERVAL ) {
        leds    = (count++) & 0xF;
    }
    t.reset();  //  timer reset
}

void isr_button2(void) {
    if ( t.read_ms() > DEBOUNCING_INTERVAL ) {
        leds    = (count--) & 0xF;
    }
    t.reset();  //  timer reset
}

int main() {
    count   = 0;
    t.start();  //  timer start
    button.rise( &isr_buton );
    button.fall(&isr_button2);
    while ( 1 ) {
    }
}