#include "mbed.h"
#include "W25Q64FV.h"
#include "Hexi_OLED_SSD1351.h"
#include "string.h"

DigitalOut led1(LED1);

Serial pc(USBTX, USBRX);

/* Instantiate the SSD1351 OLED Driver */
/* (MOSI,SCLK,POWER,CS,RST,DC) */
SSD1351 oled(PTB22,PTB21,PTC13,PTB20,PTE6, PTD15);

/**

    MOSI: PTD6
    MISO: PTD7
    SCL : PTD5
    CS : PTD4
    FREQ : 1000 000 HZ

**/
W25Q64FV flash(PTD6, PTD7, PTD5, PTD4, 8000000);

// main() runs in its own thread in the OS
int main()
{
    uint8_t buf[256] = {};

    uint16_t mau_id = 0;
    unsigned tesing_type = 0;
//    mau_id = flash.Id();
//    pc.printf("%d\n",mau_id);
//    pc.printf("%x\n",mau_id);

    flash.W25Q64_readManufacturer(buf);
    pc.printf("JEDEC ID : ");
    for (uint8_t i=0; i<5; i++) {
        pc.printf("%x", buf[i]);
        pc.printf(" ");
    }
    pc.printf("\n");

    while (true) {

        led1 = !led1;
        wait(0.5);
    }
}