#include "mbed.h"

#define INTERRUPT_MODE
//#define DIGITAL_IN_MODE

DigitalOut led(D10);

#ifdef DIGITAL_IN_MODE
//DigitalOut myled(LED1);
DigitalIn  mypin(D9);
#endif

#ifdef INTERRUPT_MODE
InterruptIn hr(D6);
Ticker  flipper;
#endif

int hr_cnt = 0; 

void flip()
{
    printf("Beat - int\n");
    led = !led;
    hr_cnt++;
}

void calculate(){
    hr_cnt = hr_cnt * 6;
    printf("Heartrate %d \n", hr_cnt);
    hr_cnt = 0;
}

int read, old_read;

int main()
{
#ifdef INTERRUPT_MODE
    hr.rise(&flip);
    flipper.attach(callback(calculate),10); // setup flipper to call flip after 2 seconds
#endif


#ifdef DIGITAL_IN_MODE
    if(mypin.is_connected()) {
        printf("mypin is connected and initialized! \n\r");
    }

    // Optional: set mode as PullUp/PullDown/PullNone/OpenDrain
    mypin.mode(PullDown);

    read = mypin.read();

    //printf("beat %d \n", read);

    printf("Waiting for heart beat...\n\n");

    while (!mypin.read()) {};
    printf("Heart beat detected!\n");
#endif

    while(1) {


#ifdef DIGITAL_IN_MODE

        read = mypin.read();
        if (read && (old_read != read)) {
            printf("Beat\n");
        }

        old_read = read;
#endif
        //printf("beat %d \n", read);
        //printf("hello \n\n");

        //led.write(0);
        //wait(1.0);
        //led.write(1);
        //wait(1.0);
//
//        myled = 1; // LED is ON
//        wait(0.2); // 200 ms
//        myled = 0; // LED is OFF
//        wait(1.0); // 1 sec
    }
}
