#include "mbed.h"
#include "TSL2561.h"
Serial      pc(USBTX, USBRX); // Serial interface
DigitalOut  sensorPowerEn(PTB12);
DigitalOut  led1(LED1);

TSL2561     lum(PTB1,PTB0);    // TSL2561 SDA, SCL
// main() runs in its own thread in the OS
int main() {
    
    sensorPowerEn = 0;
    pc.baud(115200);
    printf("who am i : %d \r\n", lum.who_am_i());

    while (true) {
        led1 = !led1;
        printf("Illuminance: %+7.2f [Lux]\r\n", lum.lux());
        wait(0.5);
        
    }
}

