#include "mbed.h"
#include "Hexi_OLED_SSD1351.h"
#include "string.h"

#define D {}

//#define DEBUG_LOGO
#define DEBUG_BUTTON
//#define DEBUG_WATCH
//#define DEBUG_APP
//#define DEBUG_WEATHER
//#define DEBUG_MOTION
//#define DEBUG_FLASHLIGHT
//#define DEBUG_NOTIFICATION


#ifdef DEBUG_LOGO
    #include "logo.h"
#endif
#ifdef DEBUG_BUTTON
    #include "button.h"
#endif
#ifdef DEBUG_WATCH
    #include "watch.h"
#endif
#ifdef DEBUG_APP
    #include "app.h"
#endif
#ifdef DEBUG_WEATHER
    #include "weather.h"
#endif
#ifdef DEBUG_MOTION
    #include "motion.h"
#endif
#ifdef DEBUG_FLASHLIGHT
    #include "flashlight.h"
#endif
#ifdef DEBUG_NOTIFICATION
    #include "notification.h"
#endif

DigitalOut led1(LED1);
SSD1351 oled(PTB22,PTB21,PTC13,PTB20,PTE6, PTD15); /* (MOSI,SCLK,POWER,CS,RST,DC) */

const uint8_t *image;

// main() runs in its own thread in the OS
int main()
{

    while (true) {
        led1 = !led1;


#ifdef DEBUG_LOGO
        image = hexiwear_logo_bmp;
        oled.DrawImage(image,0,0);
D       Thread::wait(1000);
        oled.FillScreen(COLOR_BLACK);
        Thread::wait(1000);
#endif

#ifdef DEBUG_BUTTON

        image = buttonGroup_left_bmp;
        oled.DrawImage(image,2,30);
        
        image = buttonGroup_left_bmp;
        oled.DrawImage(image,2,57);
        
D       Thread::wait(1000);
        oled.FillScreen(COLOR_BLACK);
        
        image = buttonGroup_right_bmp;
        oled.DrawImage(image,92,30);
        
        image = buttonGroup_right_bmp;
        oled.DrawImage(image,92,57);
        
D       Thread::wait(1000);
        oled.FillScreen(COLOR_BLACK);
        
        image = button_start_bmp;
        oled.DrawImage(image,50,81);
        
        Thread::wait(1000);
        oled.FillScreen(COLOR_BLACK);
        
        image = button_stop_bmp;
        oled.DrawImage(image,50,81);
        
        Thread::wait(1000);
        oled.FillScreen(COLOR_BLACK);
        
        image = button_back_bmp;
        oled.DrawImage(image,0,81);
        
        Thread::wait(1000);
        oled.FillScreen(COLOR_BLACK);
        
        Thread::wait(1000);
#endif

#ifdef DEBUG_MOTION
        image = gui_motionControl_cover_bmp;
        oled.DrawImage(image,0,0);
        Thread::wait(1000);
        
        image = gui_motionControl_acc_bmp;
        oled.DrawImage(image,0,0);
        Thread::wait(1000);
        
        image = gui_motionControl_gyro_bmp;
        oled.DrawImage(image,0,0);
        Thread::wait(1000);
#endif

#ifdef DEBUG_FLASHLIGHT
        image = flashlight_screen_bmp;
        oled.DrawImage(image,0,0);
        Thread::wait(1000);
        
        image = flashlight_off_bmp;
        oled.DrawImage(image,24,23);
        Thread::wait(1000);
        
        image = flashlight_on_bmp;
        oled.DrawImage(image,24,23);
        Thread::wait(1000);
#endif

#ifdef DEBUG_NOTIFICATION

        image = gui_notifications_screen_bmp;
        oled.DrawImage(image,0,0);
        Thread::wait(1000);

        oled.FillScreen(COLOR_WHITE);
        oled.FillScreen(COLOR_BLACK);

        image = gui_notifications_mainScreen_bmp;
        oled.DrawImage(image,0,0);
        Thread::wait(1000);

        oled.FillScreen(COLOR_WHITE);
        oled.FillScreen(COLOR_BLACK);

        image = gui_notifications_mail_white_bmp;
        oled.DrawImage(image,13,9);

        image = gui_notifications_sms_white_bmp;
        oled.DrawImage(image,16,32);

        image = gui_notifications_call_white_bmp;
        oled.DrawImage(image,16,54);
        Thread::wait(1000);
#endif


    }
}

