#include "mbed.h"
#include "FXOS8700.h"
#include "Hexi_OLED_SSD1351.h"
#include "Hexi_KW40Z.h"
#include "motion.h"
#include "button.h"
#include "string.h"
#include "font.h"

#define LED_ON      0
#define LED_OFF     1

void StartHaptic(void);
void StopHaptic(void const *n);
void ButtonRight(void);
void ButtonLeft(void);
void ButtonUp(void);
void ButtonDown(void);
void PassKey(void);


void txTask(void);
void read_accelTask(void);
void read_magTask(void);

void main_screen(void);
void accel_screen(void);
void mag_screen(void);

DigitalOut  haptic(PTB9);
DigitalOut  redLed(LED1,1);
DigitalOut  greenLed(LED2,1);
DigitalOut  blueLed(LED3,1);

Serial      pc(USBTX, USBRX);
FXOS8700    accel(PTC11, PTC10);
FXOS8700    mag(PTC11, PTC10);
SSD1351     oled(PTB22,PTB21,PTC13,PTB20,PTE6, PTD15);  // SSD1351 OLED Driver (MOSI,SCLK,POWER,CS,RST,DC)
KW40Z       kw40z_device(PTE24, PTE25);                 // Instantiate the Hexi KW40Z Driver (UART TX, UART RX)
RtosTimer   hapticTimer(StopHaptic, osTimerOnce);

Thread      tx_Thread;                                  //Create a Thread to handle sending BLE Sensor Data
Thread      Read_accelThread;
Thread      Read_magThread;

// Variables

float accel_rms = 0.0f; // RMS value from the sensor
float mag_rms = 0.0f;

const uint8_t *display_image; // Pointer for the image1 to be displayed
char text[20];
char text1[20]; // Text Buffer for dynamic value displayed
char text2[20]; // Text Buffer for dynamic value displayed
char text3[20]; // Text Buffer for dynamic value displayed

int8_t screen_num = 1;
bool ble_flag = false;


// main() runs in its own thread in the OS
int main()
{
    main_screen();
    pc.printf("init btn num : %d\n", screen_num);
    /* Register callbacks to application functions */
    kw40z_device.attach_buttonLeft(&ButtonLeft);
    kw40z_device.attach_buttonRight(&ButtonRight);
    kw40z_device.attach_buttonUp(&ButtonUp);
    kw40z_device.attach_buttonDown(&ButtonDown);
    kw40z_device.attach_passkey(&PassKey);

    accel.accel_config();
    mag.mag_config();

    //tx_Thread.start(txTask);

    while (true) {

        if(screen_num <= 0) {
            screen_num = 1;
        } else if(screen_num >= 3) {
            screen_num = 2;
        }
        blueLed = !kw40z_device.GetAdvertisementMode(); /*Indicate BLE Advertisment Mode*/
    }
}

void StartHaptic(void)
{
    hapticTimer.start(50);
    haptic = 1;
}

void StopHaptic(void const *n)
{
    haptic = 0;
    hapticTimer.stop();
}

/****************************Call Back Functions*******************************/
void ButtonRight(void)
{
    StartHaptic();
    screen_num++;

    if(screen_num == 1 || screen_num == 0) {
        main_screen();
    } else if(screen_num == 2) {
        accel_screen();
    } else {

    }

    pc.printf("btn num : %d\n", screen_num);

}

void ButtonLeft(void)
{
    StartHaptic();
    screen_num--;
    if(screen_num == 1 || screen_num == 0) {
        main_screen();

    } else if(screen_num == 2) {
        accel_screen();
    } else {
    }

    if(screen_num <= 1 && ble_flag == true) {
        kw40z_device.ToggleAdvertisementMode();
        ble_flag = false;
    }

    pc.printf("btn num af : %d\n", screen_num);
    ble_flag = true;

}

void ButtonUp(void)
{
    StartHaptic();
}

void ButtonDown(void)
{
    StartHaptic();

}

void PassKey(void)
{
    StartHaptic();
    strcpy((char *) text,"PAIR CODE");
    oled.TextBox((uint8_t *)text,0,0,95,18);

    /* Display Bond Pass Key in a 95px by 18px textbox at x=0,y=40 */
    sprintf(text,"%d", kw40z_device.GetPassKey());
    oled.TextBox((uint8_t *)text,0,15,95,18);
}

/* txTask() transmits the sensor data */
void txTask(void)
{
    float accel_data[3] = {0}; // Storage for the data from the sensor
    float mag_data[3]   = {0};
    int16_t ax, ay, az; // Integer value from the sensor to be displayed
    int16_t mx, my, mz; // Integer value from the sensor to be displayed
    
    accel.accel_config();
    mag.mag_config();

    while (true) {

        accel.acquire_accel_data_g(accel_data);

        ax = (int16_t)(accel_data[0] );
        ay = (int16_t)(accel_data[1] );
        az = (int16_t)(accel_data[2] );
        wait(0.01);
        
        mag.acquire_mag_data_uT(mag_data);
        mx = (int16_t)mag_data[0];
        my = (int16_t)mag_data[1];
        mz = (int16_t)mag_data[2];
        wait(0.01);

        /*Notify Hexiwear App that it is running Sensor Tag mode*/
        kw40z_device.SendSetApplicationMode(GUI_CURRENT_APP_SENSOR_TAG);
        kw40z_device.SendAccel(ax,ay,az);  /*Send weight using acclero service*/
        wait(0.01);
        kw40z_device.SendMag(mx, my, mz);  /*Send weight using magnitute service*/
        
        Thread::wait(1000);
    }
}

void read_accelTask(void)
{
    float accel_data[3] = {0}; // Storage for the data from the sensor
    float ax, ay, az; // Integer value from the sensor to be displayed

    while(true) {

        accel.acquire_accel_data_g(accel_data);

        ax = accel_data[0];
        ay = accel_data[1];
        az = accel_data[2];

        /* Format the value */
        sprintf(text1,"%4.2f",ax);
        /* Display time reading in 35px by 15px textbox at(x=55, y=40) */
        oled.Label((uint8_t *)text1,70,0); //Increase textbox for more digits

        /* Format the value */
        sprintf(text2,"%4.2f",ay);
        /* Display time reading in 35px by 15px textbox at(x=55, y=40) */
        oled.Label((uint8_t *)text2,70,30); //Increase textbox for more digits

        /* Format the value */
        sprintf(text3,"%4.2f",az);
        /* Display time reading in 35px by 15px textbox at(x=55, y=40) */
        oled.Label((uint8_t *)text3,70,60); //Increase textbox for more digits

        Thread::wait(500);
    }
}

void read_magTask(void)
{

    float mag_data[3]   = {0};
    float mx, my, mz; // Integer value from the sensor to be displayed
    while(1) {
        mag.acquire_mag_data_uT(mag_data);
        mx = mag_data[0];
        my = mag_data[1];
        mz = mag_data[2];

    }
}

void main_screen(void)
{

    oled_text_properties_t textProperties = {0};
    oled.GetTextProperties(&textProperties);

    /* Turn on the backlight of the OLED Display */
    // 이것을 풀면 화면의 밝기가 좀 어두워짐 .. 주석처리하는게 좋음.
    //oled.DimScreenON();

    /* Fills the screen with solid black */
    oled.FillScreen(COLOR_BLACK);

    display_image  = motion_detected_bmp;
    oled.DrawImage(display_image,0,0);

    /* Change font color to Blue */
    textProperties.fontColor   = COLOR_BLUE;
    oled.SetTextProperties(&textProperties);

    /* Display Bluetooth Label at x=17,y=65 */
    strcpy((char *) text,"BLUETOOTH");
    oled.Label((uint8_t *)text,17,80);
}

void accel_screen(void)
{

    oled_text_properties_t textProperties = {0};
    oled.GetTextProperties(&textProperties);

    /* Turn on the backlight of the OLED Display */
    // 이것을 풀면 화면의 밝기가 좀 어두워짐 .. 주석처리하는게 좋음.
    //oled.DimScreenON();

    /* Fills the screen with solid black */
    oled.FillScreen(COLOR_BLACK);

    display_image = gui_motionControl_acc_bmp;
    oled.DrawImage(display_image,0,0);
    display_image = buttonGroup_right_bmp;
    oled.DrawImage(display_image,92,30);
    display_image = buttonGroup_right_bmp;
    oled.DrawImage(display_image,92,57);
}

void mag_screen(void)
{

    oled.FillScreen(COLOR_BLACK);
    display_image = gui_motionControl_gyro_bmp;
    oled.DrawImage(display_image,0,0);
    display_image = buttonGroup_right_bmp;
    oled.DrawImage(display_image,92,30);
    display_image = buttonGroup_right_bmp;
    oled.DrawImage(display_image,92,57);

}