#include "mbed.h"
#include "HDC1000.h"
#include "Hexi_KW40Z.h"
#include "Hexi_OLED_SSD1351.h"
#include "string.h"

#define LED_ON      0
#define LED_OFF     1

void StartHaptic(void);
void StopHaptic(void const *n);
void txTask(void);
void read_task(void);

DigitalOut  haptic(PTB9);
DigitalOut  redLed(LED1,1);
DigitalOut  greenLed(LED2,1);
DigitalOut  blueLed(LED3,1);

HDC1000     hdc(PTD9,PTD8);
Serial      pc(USBTX, USBRX);
SSD1351     oled(PTB22,PTB21,PTC13,PTB20,PTE6, PTD15);  /* (MOSI,SCLK,POWER,CS,RST,DC) */
KW40Z       kw40z_device(PTE24, PTE25);                 /* Instantiate the Hexi KW40Z Driver (UART TX, UART RX) */
RtosTimer   hapticTimer(StopHaptic, osTimerOnce);

Thread      txThread;                                   /*Create a Thread to handle sending BLE Sensor Data */
Thread      readThread;

char text[20];  /* Text Buffer */

void StartHaptic(void)
{
    hapticTimer.start(50);
    haptic = 1;
}

void StopHaptic(void const *n)
{
    haptic = 0;
    hapticTimer.stop();
}

/****************************Call Back Functions*******************************/
void ButtonRight(void)
{
    StartHaptic();
    kw40z_device.ToggleAdvertisementMode();
}

void ButtonLeft(void)
{
    StartHaptic();
    kw40z_device.ToggleAdvertisementMode();
}

void PassKey(void)
{
    StartHaptic();
    strcpy((char *) text,"PAIR CODE");
    oled.TextBox((uint8_t *)text,0,25,95,18);

    /* Display Bond Pass Key in a 95px by 18px textbox at x=0,y=40 */
    sprintf(text,"%d", kw40z_device.GetPassKey());
    oled.TextBox((uint8_t *)text,0,40,95,18);
}


// main() runs in its own thread in the OS
int main()
{



    oled_text_properties_t textProperties = {0};
    oled.GetTextProperties(&textProperties);

    /* Turn on the backlight of the OLED Display */
    oled.DimScreenON();

    /* Fills the screen with solid black */
    oled.FillScreen(COLOR_BLACK);

    /* Register callbacks to application functions */
    kw40z_device.attach_buttonLeft(&ButtonLeft);
    kw40z_device.attach_buttonRight(&ButtonRight);
    kw40z_device.attach_passkey(&PassKey);

    /* Change font color to blue */
    textProperties.fontColor   = COLOR_BLUE;
    textProperties.alignParam = OLED_TEXT_ALIGN_CENTER;
    oled.SetTextProperties(&textProperties);

    /* Display Text at (x=0,y=0) */
    strcpy((char *) text,"HDC1000");
    oled.TextBox((uint8_t *)text,0,0,96,15); //Increase textbox for more digits

    textProperties.fontColor = COLOR_WHITE;
    oled.SetTextProperties(&textProperties);

    /* Display Text at (x=7,y=30) */
    strcpy((char *) text,"TEMP :");
    oled.Label((uint8_t *)text,7,30);

    /* Display Text at (x=7,y=45) */
    strcpy((char *) text,"HUMI :");
    oled.Label((uint8_t *)text,7,45);

    /* Change font color to Blue */
    textProperties.fontColor   = COLOR_BLUE;
    oled.SetTextProperties(&textProperties);

    /* Display Bluetooth Label at x=17,y=65 */
    strcpy((char *) text,"BLUETOOTH");
    oled.Label((uint8_t *)text,17,65);

    /* Change font color to white */
    textProperties.fontColor   = COLOR_WHITE;
    textProperties.alignParam = OLED_TEXT_ALIGN_CENTER;
    oled.SetTextProperties(&textProperties);

    /* Display Label at x=22,y=80 */
    strcpy((char *) text,"Tap Below");
    oled.Label((uint8_t *)text,22,80);

    txThread.start(txTask); /*Start transmitting Sensor Tag Data */
    readThread.start(read_task);

    while (true) {

        blueLed = !kw40z_device.GetAdvertisementMode(); /*Indicate BLE Advertisment Mode*/
        Thread::wait(50);
    }
}

/* txTask() transmits the sensor data */
void txTask(void)
{
    while (true) {

        hdc.get();    // Triger conversion

        /*Notify Hexiwear App that it is running Sensor Tag mode*/
        kw40z_device.SendSetApplicationMode(GUI_CURRENT_APP_SENSOR_TAG);
        /*Send weight using pressure service*/
        kw40z_device.SendTemperature(hdc.send_temp());
        kw40z_device.SendHumidity(hdc.send_humi());
        Thread::wait(1000);
    }
}

void read_task(void)
{

    char t_temp[10] = {0}, s_temp[10] = {0};
    char t_humi[10] = {0}, s_humi[10] = {0};
    float temp = 0.0f, humi = 0.0f;
    int16_t i_temp = 0;
    uint16_t u_temp = 0, u_humi = 0;

    while(true) {

        hdc.get();    // Triger conversion
        pc.printf("Temp: %+4.1fC, Humid: %4.1f%%\r\n", hdc.temperature(), hdc.humidity());
        temp = hdc.temperature();
        humi = hdc.humidity();
        sprintf(t_temp,"%4.1fC",temp);
        sprintf(t_humi,"%4.1f%%",humi);
        i_temp = (int)(hdc.temperature());
        u_temp = hdc.send_temp()/ 1000;
        u_humi = hdc.send_humi()/ 1000;
        pc.printf("int Temp: %d \r\n", i_temp);
        pc.printf("unsigned Temp: %d, Humid: %u\r\n", u_temp, u_humi);

        oled.TextBox((uint8_t *)t_temp,40,30,46,15); //Increase textbox for more digits
        oled.TextBox((uint8_t *)t_humi,40,45,46,15); //Increase textbox for more digits

        Thread::wait(2000);
    }
}
