/* Copyright (c) 2010 iZsh - izsh at fail0verflow.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
// Based on
// http://www.irongeek.com/i.php?page=security/barcode-flashing-led-fuzzer-bruteforcer-injector

#include "mbed.h"
#include "BarcodeLED.h"

typedef struct
{
    const char * str;
    const char * descr;
} str_t;

void readline(char Buffer[], int Size)
{
    int i = 0;
    char c;
        
    while ((c = fgetc(stdin)) != '\r' && i < Size - 1) {
        putc(c, stdout);
        Buffer[i++] = c;
    }
    Buffer[i] = '\0';
}

void prompt(const str_t Barcodes[])
{
    printf("\r\n");
    printf("=============\r\n");
    printf("command list:\r\n");
    printf("=============\r\n");
    printf("code <39 | 128a | 128b | 128c>\r\n");
    printf("preset <num>\r\n");
    for (int i = 0; i < 6; ++i)
        printf("\t%d: %s\r\n", i, Barcodes[i].descr);
    printf("send <string>\r\n");
    printf("> ");
}

// Very primitive parsing...
void parse(const char Line[], const str_t Barcodes[], BarcodeLED & Barcode)
{
    printf("\r\n");
    if (!strcmp(Line, "code 39")) {
        Barcode.SetCodetype(BarcodeLED::Code39);
        printf("Setting barcode to Code39\r\n");
    } else if (!strcmp(Line, "code 128a")) {
        Barcode.SetCodetype(BarcodeLED::Code128a);
        printf("Setting barcode to Code128a\r\n");
    } else if (!strcmp(Line, "code 128b")) {
        Barcode.SetCodetype(BarcodeLED::Code128b);
        printf("Setting barcode to Code128b\r\n");        
    } else if (!strcmp(Line, "code 128c")) {
        Barcode.SetCodetype(BarcodeLED::Code128c);
        printf("Setting barcode to Code128c\r\n");
    } else if (!strncmp(Line, "preset ", 7)) {
        int num = -1;
        sscanf(Line, "preset %d", &num);
        if (num != -1 && num < 6)
            Barcode.Emit(Barcodes[num].str);
        else
            printf("=> Unknown string ID!\r\n");
    } else if (!strncmp(Line, "send ", 5)) {
        Barcode.Emit(Line + 5);
    } else {
        printf("=> Command not found!\r\n");
    }
}

int main()
{
    BarcodeLED barcode(LED1, BarcodeLED::Code39);
    DigitalOut led(LED4);

    str_t barcodes[] = {
        {"0123456789", "numeric"},
        {"abc123", "simple alphanum"},
        {"<script>alert(\"Hello World!\")</script>", "XSS"},
        {"' or 1=1 -- ", "SQL injection"},
        {"X5O!P%@AP[4\\PZX54(P^)7CC)7}$EICAR-STANDARD-ANTIVIRUS-TEST-FILE!$H+H*", "EICAR test string"},
        {"TRY TO PASTE v", "Ctrl-V in 128a"},
    };

    barcode.SetVerbose(true);

    while(1) {
        char buffer[512];
        memset(buffer, '\0', 512);
        prompt(barcodes);
        readline(buffer, 512);
        parse(buffer, barcodes, barcode);
        led = 1;
        wait(0.2);
        led = 0;
        wait(0.2);
    }
}
