/* Copyright (c) 2010 iZsh - izsh at fail0verflow.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 #ifndef IZSH_MBED_BARCODELED_H
 #define IZSH_MBED_BARCODELED_H
 
 #include "mbed.h"
 
 class BarcodeLED
 {
    public:
    enum CodeType
    {
        Code39,
        Code128a = 103,
        Code128b = 104,
        Code128c = 105,
    };
 
    BarcodeLED(const PinName Led, const CodeType Codetype = Code39, const int BaseDelay = 20);
    
    CodeType GetCodetype();
    void SetCodetype(const CodeType Codetype);
    
    int GetBaseDelay();
    void SetBaseDelay(const int BaseDelay);
    
    int GetVerbose();
    void SetVerbose(const bool Verbose);
    
    void Emit(const char Str[]);
    
    private:
    
    void EmitCode39(const char Str[]);
    void EmitCode128(const char Str[]);
    
    int ASCII2Code39(const char C);
    int ASCII2Code128(const char C);

    char * RevStr(char Str[]);
    void FlashSeq(const char Seq[]);
    
    int Code128Checksum(const char Str[]);
    
    DigitalOut m_Led;
    CodeType m_Codetype; 
    int m_BaseDelay;
    bool m_Verbose;
    
    static const char * m_Barcode39[];
    static const char * m_Barcode128[];
 };
 
 
 #endif