// *********************************************************************************************************************************************************
//  Settings                                                                                                                                               *
// *********************************************************************************************************************************************************
// Serial Settings
#define DEBUG_TO_SERIAL         1   // Echo to PC serial
#define SD_CARD                 1   // Are we using a SD card at this moment?
#define SECONDS_BETWEEN_MESSAGE 1   // How long between sending a "i'm online" message


// Servo positioning
#define intPos                  0.2     // Position for locking the chute
#define rlsPos                  1.0     // Position for releasing the chute





// *********************************************************************************************************************************************************
//  Includes                                                                                                                                               *
// *********************************************************************************************************************************************************
#include "mbed.h"               // Mbed library
#include "SDFileSystem.h"       // SD Libary
#include "MMA8451Q.h"           // Built-in Accelerometer Libary
#include "TSISensor.h"          // Built-in Touch-sensor Libary
#include "MPL3115A2.h"          // MPL3115A2 Libary Altitude & pressure sensor
#include "Servo.h"              // Servo library




// *********************************************************************************************************************************************************
//  Definitions                                                                                                                                            *
// *********************************************************************************************************************************************************
// Adress for the I2C sensors
#define MPL3115A2_I2C_ADDRESS (0x60<<1)     // Alt & temp sensor
#define MMA8451_I2C_ADDRESS   (0x1d<<1)     // Accelerometer


// Calibrating the servo
#define calFirst                0.0010  // First value for calibration
#define calSecond               90.0    // Second value for calibration


// Messages expected to be recieved. In DEC instead of char!
//#define MESSAGE_LP_ONLINE  49    // Online message from LaunchPad (LP) 49 DEC
//#define MESSAGE_RKT_ONLINE 50    // Online message from Rocket (RKT)
//#define MESSAGE_RKT_RDY    52    // Rocket beginning countdown sequence
//#define MESSAGE_LP_RDY     53    // LaunchPad beginning countdown sequence


// Messages expected to be sending.
//#define CONFIRM_ONLINE     8     // Prints "8" in DEC for confirmation to launchpad and rocket (dec 56)
//#define CONFIRM_LAUNCH     3    // "3" for Launch


// Confirmations expected to be sent
#define CONFIRM_ONLINE      0x32    // HEX for "2" - the "i'm online!" message
#define CONFIRM_LAUNCH      0x34    // HEX for "4" - The "OK we'll launch soon"

// Messages expected to recieve
#define MESSAGE_KTP_ONLINE  0x38    // HEX for "8" - Kontrolpanel confirms connection
#define MESSAGE_KTP_LAUNCH  0x33    // HEX for "3" - LAUNCH command from Kontrolpanel
#define MESSAGE_KTP_SD      0x41    // HEX for "A" - For starting to save data to the SD card. Used in pre-launch (in countdown sequence)

// *********************************************************************************************************************************************************
//  Constructors                                                                                                                                           *
// *********************************************************************************************************************************************************
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);            // Built-in Accelerometer
MPL3115A2 wigo_sensor1( PTE0, PTE1, MPL3115A2_I2C_ADDRESS); // Pressure- and temperature-sensor!
TSISensor tsi; //-------------------------------------------// TouchSensor på Mbed'en 
SDFileSystem sd(PTD2, PTD3, PTD1, PTD0, "sd");              // SD Shield
Serial pc(USBTX, USBRX);                                    // Serial w/ PC through wire
Serial XB(PTC4, PTC3);                                      // Serial XBee

Timer t;                                                    // Timer "t" for keeping track of time



// *********************************************************************************************************************************************************
//  Helper-functions for the Altimeter                                                                                                                     *
// *********************************************************************************************************************************************************
float print_PressureValue( unsigned char *dt);
float print_AltimiterValue( unsigned char *dt);
float print_TemperatureValue( unsigned char *dt);
float sensor_data[2];
void dataready( void);      // callback function for data streaming using Interrupt
void alttrigger( void);







// *********************************************************************************************************************************************************
//  Variables                                                                                                                                              *
// *********************************************************************************************************************************************************
// Filecreation
int fileOpen = 0;
char fileName[23] = "/sd/mydir/LOGGER00.CSV";


// *********************************************************************************************************************************************************
//  Setup                                                                                                                                                  *
// *********************************************************************************************************************************************************
int main(){
    Servo myservo(PTA4);

    myservo.calibrate(calFirst, calSecond);
    myservo.write(intPos);
    

    #if DEBUG_TO_SERIAL
    pc.baud(9600);
    #endif
    XB.baud(9600);
    
    
    // ***********************************************
    //  Setting up the altimeter & temp sensor       *
    // ***********************************************
    
    wigo_sensor1.Oversample_Ratio( OVERSAMPLE_RATIO_8); // Set over sampling value (see MPL3115A2.h for details)
    wigo_sensor1.Altimeter_Mode();                      // Configure the sensor
   
   
    // ***********************************************
    //  Filecreating                                 *
    // ***********************************************   
    #if DEBUG_TO_SERIAL
    XB.printf("SD Namecalling\n");
    #endif
    
    #if SD_CARD
    mkdir("/sd/mydir", 0777); // Making the folder in where to put the file
    int i = 1;
    nameFinder:
    fileName[18] = '.';                 // Making the dot in .CSV
    fileName[17] = i%10 + '0';          // Numbering the filename
    fileName[16] = i/10 + '0';          // to something not already there
    i++;
    FILE *fp = fopen(fileName, "r" );   // This checks if there is a file called fileName
    if(fp != NULL){
        #if DEBUG_TO_SERIAL
        XB.printf("File existed.\n");
        #endif
        
        goto nameFinder;
    }
    
    if(fp == NULL){
        #if DEBUG_TO_SERIAL
        XB.printf("fileName %c did not exist, creating one now!\n", fileName );
        XB.printf(fileName);
        XB.printf("\n");
        #endif
        
        fp = fopen(fileName, "w" ); // This creates a file called fileName
        if(fp == NULL){
            error("failed");
            }
    }
    #if DEBUG_TO_SERIAL
    XB.printf("SD File created in the Rocket.\n");
    #endif
    #endif //if SD
    
    
    
    
    
    
    
    
    
    
    
    
        
    // ***********************************************
    //  Mode 0: Handshaking with KTP                 *
    // ***********************************************
    t.start();
    int time1 = t.read();
    bool confirmed_rdy = false;
    
    while(confirmed_rdy == false){
        if(time1 - t.read() >= SECONDS_BETWEEN_MESSAGE * 1000){
            XB.putc(CONFIRM_ONLINE);
            time1 = t.read();
        }// if
        
        while(time1 - t.read() < SECONDS_BETWEEN_MESSAGE * 1000){
            if(XB.getc() == MESSAGE_KTP_ONLINE){
                t.stop();
                confirmed_rdy = true;
            }// if        
        }// While time
    }// while !confirmed_rdy
// *********************************************************************************************************************************************************
//  Loop                                                                                                                                                   *
// *********************************************************************************************************************************************************
while(1){
    // ***********************************************
    //  Mode 1: Listening for MESSAGE_KTP_SD         *
    // ***********************************************        
    bool confirmed_sd = false;
    while(confirmed_sd == false){
        if(XB.readable()){
            if(XB.getc() == MESSAGE_KTP_SD){
                confirmed_sd = true;    
            }// if MESSAGE_KTP_SD
        }// if READABLE
    }// while Mode 1
    // ***********************************************
    //  Mode 2: Start logging data to SD             *
    // ***********************************************
      
    
    

}// While loop. The code should stop looping after this point. Keep this close to "Recovered stage"
// *********************************************************************************************************************************************************
//  Recovered stage: Writes end-message to SD-card datastream.                                                                                             *
// *********************************************************************************************************************************************************




}// main