//  #########################################################
//  Includes                                                # 
//  #########################################################
#include "mbed.h"               // Mbed library
#include "SDFileSystem.h"       // SD Libary
#include "MMA8451Q.h"           // Built-in Accelerometer Libary
#include "TSISensor.h"          // Built-in Touch-sensor Libary

//  #########################################################
//  Define settings                                         # 
//  #########################################################
#define SD_CARD 1

//  #########################################################
//  Adresses for talking to the I2C sensors                 # 
//  #########################################################
#define MMA8451_I2C_ADDRESS   (0x1d<<1)     // Accelerometer


//  #########################################################
//  Constructors                                            #
//  #########################################################
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);            // Built-in Accelerometer
SDFileSystem sd(PTD2, PTD3, PTD1, PTD0, "sd");              // the pinout on the mbed Cool Components workshop board
Serial pc(USBTX, USBRX);                                    // Serial w/ PC through wire
TSISensor tsi; //-------------------------------------------// TouchSensor på Mbed'en 


//  #########################################################
//  Global Variables                                        #
//  #########################################################
int fileOpen = 0;
char fileName[23] = "/sd/mydir/LOGGER00.CSV";
int T1 = 0;
int T2 = 0;






int main(){
    
    
pc.baud(9600);
Timer t;


T1 = tsi.readDistance(); 

// ----------------------------------------------------------
// Setup part - This only runs ONCE
// ----------------------------------------------------------
    t.start();
    t.reset();
    #if SD_CARD
    mkdir("/sd/mydir", 0777); // Making the folder in where to put the file
    int i = 1;
    nameFinder:
    fileName[18] = '.';                 // Making the dot in .CSV
    fileName[17] = i%10 + '0';          // Numbering the filename
    fileName[16] = i/10 + '0';          // to something not already there
    i++;
    FILE *fp = fopen(fileName, "r" );   // This checks if there is a file called fileName
    if(fp != NULL){
        printf("Going to namefinder %i \n", i);
        goto nameFinder;
    }
    
    if(fp == NULL){    
        printf("Wuhu");    
        fp = fopen(fileName, "w" ); // This creates a file called fileName
        if(fp == NULL){
            printf("\nFAILED\n");
            error("failed");
            }
    }
    #endif
    
    
    
        #if SD_CARD
    fprintf(fp, "X,Y,Z,Altitude,Temperature \n");        // Prints a header telling Excel what sort of information is in which place


    fprintf(fp, "Hej, Hej, BOV \n");
    

    #endif
    
    
// ----------------------------------------------------------
// Loop part - This runs AFTER setup
// ----------------------------------------------------------
    while(1){
        /*
        float XYZ[3];
        acc.getAccAllAxis(XYZ);
    
        for(int i = 0; i < 3; i++){
            printf("XYZ[%i]: %f", i, XYZ[i]);
        };
        */
        float x = 0;
        float y = 0;
        float z = 0;
        x = acc.getAccX();   //
        y = acc.getAccY();   //-> Getting accelerometer-information
        z = acc.getAccZ();   //
        fprintf(fp, "%f, %f, %f, %f \n", x, y, z,t.read());
        printf("X: %f\t  Y: %f\t  Z: %f \n", x, y, z);
        
        T2 = tsi.readDistance();
        if(T2-T1 > 0.5){
            break;         // Makes the loop stop.
        }    
        
        wait(0.01);
    }// while

    fclose(fp); // Closes the SD card. Do this after every write

}// main
