#include "mbed.h"

// Labs 2:  polling 
// --------------------------------------------

DigitalIn b1(PTD0, PullUp);             // initialize the button  
DigitalOut led(LED1);                   // initialize the led

Thread pollT ;                            // thread to poll
volatile int pressEvent = 0 ;             // Variabe set by the polling thread


enum buttonPos { up, down, bounce };     // Button positions
void polling() {                       
    buttonPos pos = up ;                  //initialize the button  position 
    int bcounter = 0 ;                    //initialize the counter
    while (true) {
        ThisThread::sleep_for(30) ;       // poll every 30ms
        switch (pos) {
            case up :
                if (!b1.read()) {            // now down 
                    pressEvent = 1 ;        // transition occurred
                    pos = down ;            // change to down position 
                }
                break ;
            case down : 
                if (b1 == 1) {                  // no longer down
                    bcounter = 3 ;              // wait four cycles
                    pos = bounce ;              //change to bounce position
                }
                break ;
            case bounce :
                if (b1 == 0) {                // down again - button has bounced
                    pos = down ;                 // no event
                } else if (bcounter == 0) {
                    pos = up ;                  // delay passed - reset to up
                } else {
                    bcounter-- ;               // continue waiting
                }
                break ;
        }
    }
}

/*  ---- Main function (----
 */
int main() {
    led = 0 ;                                       // Initially off
    pollT.start(callback(polling));
    int i=0;                                       //create a counter for controling the speed of LED
    int flashspeed[]={200, 400, 600, 800, 1000};    //input the value for chaging the speed of LED
    while(true) {
        if (pressEvent) {
            pressEvent = 0 ;                            // clear the event variable
            i++ ;                                       // counter add one 
            if (i>4){                                   // when counter is bigger than four change back to zero
            i=0; 
            }
        }
        led =!led;                                    //  led blinks 
        ThisThread::sleep_for(flashspeed[i]) ;        //   delay for 200ms 400ms 600ms 800ms 1s then come back to 200ms
    }
}