#include "mbed.h"

InterruptIn button(PTD0);                             // Pin must be on ports A or D
InterruptIn button2(PTD2);                           //another button uses pin PTD2
DigitalOut led(LED_BLUE);                          // choose blue LED
DigitalOut led2(LED_RED);                         //choose another RED LED 

volatile int pressEvent = 0 ;              
volatile int pressEvent2 = 0 ;

void buttonCallback(){                              //when the first button is pressed,change the signal to the opposite value 
    pressEvent = !pressEvent;  
}
void buttonCallback2(){                            //when the second button is pressed,change the signal to the opposite value 
    pressEvent2 = !pressEvent2 ;            
}
/*  ---- Main function ----
 */
int main() {
    button.mode(PullUp);                           // Ensure button i/p has pull up
    button.fall(&buttonCallback) ;                 // Attach function to falling edge
    button2.mode(PullUp);                          // Ensure the second button i/p has pull up
    button2.fall(&buttonCallback2) ;               // Attach function to falling edge    
    while(true) {
                                                 // Toggle the LED every time the button is pressed 
        if (pressEvent) {
            led = !led ;                         // when the signal arrived, change led1
        }
        if (pressEvent2) {
            led2 = !led2 ;                       // when the signal arrived, change led2
        }               
        ThisThread::sleep_for(500) ;             // delay for 500ms 
    }
}