#include "mbed.h"
#include "wdt.h"

// -----------DESCRIBTION-------------
// lab6 second part of the demostration,
//all the functions have been tested
// -----------------------------------------------

#define ON 1
#define OFF 0
DigitalOut led_red(LED_RED, ON);
DigitalIn button(PTD0, PullUp);
DigitalOut led1(PTC12, OFF);
AnalogIn ain(A0) ;          // Analog input
Serial pc(USBTX, USBRX); // tx, rx, useful for debugging
// This ticker is used to feed the watch dog
Ticker tick;

// Threads
Thread threadT ; // timer thread
Thread threadLED1 ; // thread LED1
Thread threadADC ;  //thread for ADC
# define ON1 0x01
# define OFF1 0x02

EventFlags signals;  // event flags for signalling
void waitButton()
{
    while (!button) ;
}

float voltage;  //value for voltage
int t;
// ---Thread for controlling LED 1----------------
//   Turn LED1 on/off in response to signals
// -----------------------------------------------
void led1_thread()    // method to run in thread
{
    int evt ;
    while (true) {
        evt = signals.wait_any(ON1 | OFF1); // wait for either signal
        if (evt & ON1) led1 = ON ;
        if (evt & OFF1) led1 = OFF ;
        waitButton() ;  // POSSIBLE FAULT HERE
    }
}

// ---Thread for controlling LED 2----------------
//   Turn LED2 on/off in response to signals
// -----------------------------------------------
/*
void led2_thread()    // method to run in thread
{
    int evt ;
    while (true) {
        evt = signals.wait_any(ON2 | OFF2); // wait for any signal
        if (evt & ON2) led2 = ON ;
        if (evt & OFF2) led2 = OFF ;
        wdt_kickB();
        waitButton() ; // POSSIBLE FAULT HERE
    }
}
*/
void adc_thread()   // method to run in thread
{
    while(true) {
        voltage = ain.read()*3.3f;             //read from adc
        if (t == 0 && voltage > 0) {          //if  led should be off and the volt is out of range
            led_red = 0;                      //turn on internal led
        }
        if(t == 1 && (voltage < 1 || voltage > 2)) { //if  led should be on and the voltage is out of range
            led_red = 0;                             //turn on internal led
        }
        pc.printf("currrnt_Voltage%3.3f%\n", voltage);   // print on the screen
        ThisThread::sleep_for(1000) ;          //delay
    }
}

// ---Thread for timing --------------------------
//   Send signals to the other threads
// -----------------------------------------------
void timer_thread()    // method to run in thread
{
    while (true) {
        ThisThread::sleep_for(1000) ;   //delay
        signals.set(ON1) ;
        t = 1;                       //check the signal
        ThisThread::sleep_for(1000) ;    //delay
        signals.set(OFF1) ;
        t = 0;                       //check the signal
    }
}

// -----------MAIN-------------------------------
//run the three threads
// ----------------------------------------------

int main(void)
{
    wdt_32ms() ; // initialise watchdog - 32ms timeout
    wdt_kick_all() ;
    tick.attach_us(callback(&wdt_kick_all), 20000); // ticks every 20ms

    // start threads
    threadT.start(timer_thread) ; // start the timer thread
    threadLED1.start(led1_thread) ; // start the LED1 control thread
    threadADC.start(adc_thread) ; // start the adc thread

    // main thread does nothing more
    while (true) {
        ThisThread::sleep_for(10000) ; //delay
    }
}