#include "mbed.h"
#include "TSISensor.h"
//  program for lab 5
// -------------------------
// Implement the functions of four virtual buttons

Serial pc(USBTX, USBRX);   // tx, rx
DigitalOut yellowLED(D6);     // yellow led port
DigitalOut greenLED(D7);      // green led port
DigitalOut redLED(D8);         // red led port
DigitalOut blueLED(D9);        //blue led port


TSISensor tsi;

Thread redThread ; // thread for red LED
Thread greenThread ; // thread for green LED
Thread blueThread; // thread for blue LED
Thread yellowThread; //thread for yellow LED
# define REDFLAG 0x01   
# define GREENFLAG 0x02
# define BLUEFLAG 0x04
# define YELLOWFLAG 0x08

EventFlags signals;  // eventflag signal, uesd for comunicate 
enum pos {none, leftIn, leftOut, rightIn, rightOut}; // 5 states for the buttons

void red_thread() {  // thread for red LED
    while (true) {
        signals.wait_any(REDFLAG);
        redLED = !redLED ; //  on&off
        ThisThread::sleep_for(1000) ; // delay
        signals.clear(REDFLAG) ;        // clear the signal flag for futher use
    }
}

void green_thread() {  // thread for green LED
    while (true) {
        signals.wait_any(GREENFLAG);
        greenLED = !greenLED ; //  on&off
        ThisThread::sleep_for(1000) ; // delay
        signals.clear(GREENFLAG) ;        // clear the signal flag for futher use
    }
}

void blue_thread() {  // thread for blue LED
    while (true) {
        signals.wait_any(BLUEFLAG);
        blueLED = !blueLED ; //  on&off
        ThisThread::sleep_for(1000) ; // delay
        signals.clear(BLUEFLAG) ;        // clear the signal flag for futher use
    }
}

void yellow_thread()    // thread for yellow LED
{
    while (true) {
        signals.wait_any(YELLOWFLAG);
        yellowLED = !yellowLED ; //  on&off
        ThisThread::sleep_for(1000) ; // delay
        signals.clear(YELLOWFLAG) ;        // clear the signal flag for futher use
    }
}

int main(void) {
    redLED = 0 ; 
    greenLED = 0 ; 
    blueLED = 0; 
    yellowLED = 0;  // beginning state for the four LEDs
    int pos = none; // initialise state
    redThread.start(red_thread) ; //  red LED thread
    greenThread.start(green_thread) ; //  green LED thread
    blueThread.start(blue_thread);//  blue LED thread
    yellowThread.start(yellow_thread);// yellow LED thread
    
    while (true) {
        uint8_t d = tsi.readDistance() ;  // read the variables form the touchpad
        switch (pos){ 
        
            case none: // none state
                if (d > 3 && d < 9) 
                {signals.set(YELLOWFLAG);pos = leftOut;}
                 // if in range inside 3 - 9, left out button
 
                if (d > 13 && d < 19) 
                {signals.set(BLUEFLAG);pos = leftIn;}
                // if in range inside 13 - 19, leftin button

                if (d > 23 && d < 29) 
                {signals.set(GREENFLAG);pos = rightIn;}
                // if in range inside 23 - 29, right in button

                if (d > 33) 
                {signals.set(REDFLAG);pos = rightOut;}
                // if in range d bigger 33 ,right out button
                break;
                
            case leftIn: 
                if(d < 13 || d > 19) 
                pos = none; // if out of the range, state goes back to none
                break;
                
            case leftOut:
                if(d < 3 || d > 9) 
                pos = none;// if out of the range, state goes back to none
                break;
            case rightIn:
            // case right in
                if(d < 23 || d > 29) 
                pos = none;// if  out of the range, state goes back to none
                break;
            case rightOut:// case right out
                if(d < 33) 
                pos = none;// if  out of the range, state goes back to none
                break;
        }

        pc.printf("%d", d) ;  
        pc.printf("%d", pos) ;  
        pc.putc(' ') ;
        ThisThread::sleep_for(1000) ;
 
    }
}