#include "mbed.h"
#include "wdt.h"
 
 // ------------Fault Injection Button-------------
// lab6 first part of the demostration, 
//all the functions have been tested 
// -----------------------------------------------

#define ON 1     
#define OFF 0
DigitalOut led_red(LED_RED, ON);
DigitalIn button(PTD0, PullUp);
DigitalOut led1(PTC12, OFF);
DigitalOut led2(PTC13, OFF); // all the beginning sets 
Serial pc(USBTX, USBRX); // tx, rx, useful for debugging
 
// This ticker is used to feed the watch dog
Ticker tick;
 
// Threads
Thread threadT ; // timer thread 
Thread threadLED1 ; // thread LED1
Thread threadLED2 ; // thread LED2
 
# define ON1 0x01   
# define ON2 0x02
# define OFF1 0x04   
# define OFF2 0x08
EventFlags signals;  // event flags for signalling
 
 
void waitButton() {
    while (!button) ;  
}
 
// ---Thread for controlling LED 1----------------
//   Turn LED1 on/off in response to signals 
// -----------------------------------------------
void led1_thread() {  // method to run in thread
    int evt ;
    while (true) {
        evt = signals.wait_any(ON1 | OFF1); // wait for either signal
        if (evt & ON1) led1 = ON ;
        if (evt & OFF1) led1 = OFF ;
        wdt_kickA();
        //waitButton() ;  // POSSIBLE FAULT HERE
    }
}
 
// ---Thread for controlling LED 2----------------
//   Turn LED2 on/off in response to signals 
// -----------------------------------------------
void led2_thread() {  // method to run in thread
    int evt ;
    while (true) {
        evt = signals.wait_any(ON2 | OFF2); // wait for any signal
        if (evt & ON2) led2 = ON ;
        if (evt & OFF2) led2 = OFF ;
        wdt_kickB();
        //waitButton() ; // POSSIBLE FAULT HERE
    }
}
 
// ---Thread for timing --------------------------
//   Send signals to the other threads
// -----------------------------------------------
void timer_thread() {  // method to run in thread
    while (true) {
        ThisThread::sleep_for(1000) ;
        signals.set(ON1 | ON2) ;
        ThisThread::sleep_for(1000) ;
        signals.set(OFF1 | OFF2) ;
        waitButton() ; // POSSIBLE FAULT HERE
    }
}
 
// -----------MAIN-------------------------------
//    Configure watchdog. Start threads. 
//    Show start up with RED for 1sec
//    Remember the watchdog is running
//       - 1024ms to set it once
//       - then must feed it every 32ms  
// ----------------------------------------------
 
int main(void) {
    wdt_1sec() ; // initialise watchdog - 1sec timeout
    wdt_kick_all() ;  
    // start threads
    threadT.start(timer_thread) ; // start the timer thread 
    threadLED1.start(led1_thread) ; // start the LED1 control thread 
    threadLED2.start(led2_thread) ; // start the LED2 control thread    
    // show start-up
    led_red = OFF;
    ThisThread::sleep_for(5000) ;
    led_red = ON;
    
    // main thread does nothing more
    while (true) {
        ThisThread::sleep_for(10000) ; //delay 
    }
}