#include "mbed.h"
#include "MMA8451Q.h"

PinName const SDA = PTE25;
PinName const SCL = PTE24;
EventQueue queue;
Serial pc(USBTX, USBRX); // tx, rx
  
Thread eventThread ;
DigitalOut rled(LED1); //red led
DigitalOut gled(LED2); //green led
DigitalOut bled(LED3); //blue led


EventFlags event_flags;
Timer A1;
#define MMA8451_I2C_ADDRESS (0x1d<<1)
enum pos {up, down, left, right, flat, over, intermediate};
volatile int pos = intermediate;
enum state {first, second, third, success, e};
volatile int state = first;
volatile uint32_t flags_read = 1;

void seqchecking()
{
    switch(state) {
        case first:
            flags_read = event_flags.wait_any(up|down|right|left|over|flat|intermediate,10000,true);
            pc.printf("flag_read:%d\r\n", flags_read);
            //if(flags_read == -2){rled = 1;}
            //else{
            if(flags_read == 4) {
                if(flags_read == -2) {
                    state = second;
                    A1.reset();
                    pc.printf("turn right please");
                }
            }
            if(flags_read != 4 && A1.read() < 10) {
                state = e;
            }
            if((flags_read != 4 && flags_read != 6) && A1.read() < 10) {
                state = e;
                pc.printf("b");
            }
            //}
            break;
        case second:
            flags_read = event_flags.wait_any(up|down|right|left|over|flat|intermediate,6000,true);
            if(flags_read != 3 && A1.read() < 2) {
                state = e;
            }
            if(flags_read == 0 && A1.read() >= 2) {
                state = second;
                A1.reset();
                pc.printf("turn upward please");
            }
            if((flags_read != 3 && flags_read != 0)) {
                state = e;
            }
            break;
        case third:
            flags_read = event_flags.wait_any(up|down|right|left|over|flat|intermediate,8000,true);
            if(flags_read != 0 && A1.read() < 4) {
                state = e;
            }
            if(flags_read == 4 && A1.read() >= 4) {
                state = second;
                A1.reset();
            }
            if((flags_read != 4 && flags_read != 0)) {
                state = e;
            }
            break;
        case success:
            gled = 0;
            break;
        case e:
            rled = 0;
            event_flags.wait_any(flat, osWaitForever, true);
            state = first;
            A1.reset();
            break;
    }
}
int main(void)
{
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    


    pc.printf("MMA8451 ID: %d\n", acc.getWhoAmI());
    
    rled = 1; // turn off all leds when initialising
    gled = 1;
    bled = 1;
    x.start();
    eventThread.start(callback(&queue, &EventQueue::dispatch_forever));
    queue.call_every(10, seqchecking) ; 
    while (true) {
        float x, y, z;
        x = acc.getAccX(); // get x axis value
        y = acc.getAccY(); // get y axis value
        z = acc.getAccZ(); // get z axis value
        ThisThread::sleep_for(300);  // wait(0.3);
        
        switch (pos){
            case intermediate:
                if(x > 0.9){ //if the board is in position down
                    pos = down;
                    event_flags.set(down);
                    pc.printf("down\n"); // print up on pc screen
                }
                if(x < -0.9){ //if the board is in position up
                    pos = up;
                    event_flags.set(up);
                    pc.printf("Up\n");// print down on pc screen
                }
                if(y > 0.9){ //if the board is in position left
                    pos = left;
                    event_flags.set(left);
                    pc.printf("left\n");// print left on pc screen
                }
                if(y < -0.9){ //if the board is in position right
                    pos = right;
                    event_flags.set(right);
                    pc.printf("right\n");// print right on pc screen
                }
                if(z > 0.9){ //if the board is in position flat
                    pos = flat;
                    event_flags.set(flat);
                    pc.printf("Flat\n");// print flat on pc screen
                }
                if(z < -0.9){ //if the board is in position over
                    pos = over; 
                    event_flags.set(over);
                    pc.printf("Over\n");// print over on pc screen
                }
                if(z<0.8 && z>-0.8 && x<0.8 && x>-0.8 && y<0.8 && y>-0.8){
                    pos = intermediate;
                    event_flags.set(intermediate);
                }
                break;
                        case flat:
                if(z<0.8) {
                    pos=intermediate;
                }
                break;

            case over:
                if(z>-0.8) {
                    pos=intermediate;
                }
                break;

            case left:
                if(y>-0.8) {
                    pos=intermediate;
                }
                break;

            case right:
                if(y<0.8) {
                    pos=intermediate;
                }
                break;

            case up:
                if(x<0.8) {
                    pos=intermediate;
                }
                break;

            case down:
                if(x>-0.8) {
                    pos=intermediate;
                }
                break;
        }

        }
            
    }
}
