#include "mbed.h"
#include "MMA8451Q.h"

  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
  

#define MMA8451_I2C_ADDRESS (0x1d<<1)
int main(void)
{
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    DigitalOut rled(LED1);    //set red led 
    DigitalOut gled(LED2);    //set green led 
    DigitalOut bled(LED3);    //set blue led 
    Serial pc(USBTX, USBRX); // tx, rx


    pc.printf("MMA8451 ID: %d\n", acc.getWhoAmI());
    enum accPos {intermediate, flat,over,right,left,up,down };     // the acc positions
    accPos pos = intermediate ;     //the beginning state

    while (true) {
        float x, y, z;
        x = acc.getAccX();   // get value for x axis
        y = acc.getAccY();   // get value for y axis
        z = acc.getAccZ();   // get value for z axis
        switch(pos) {

            case intermediate :  //intermediate stae, get all led off
                rled=1;
                gled=1;
                bled=1;

                if(z>0.9) {      //when z >0.9 go to flat pos
                    bled=0;
                    pos=flat;
                    pc.printf("flat\n");
                }
                if(z<-0.9) {    //when z <-0.9 go to over pos
                    bled=0;
                    pos=over;
                    pc.printf("over\n");
                }

                if(y<-0.9) {     //when y <-0.9 go to left pos
                    gled=0 ;
                    pos=left;
                    pc.printf("left\n");
                }

                if (y>0.9) {     //when y >0.9 go to right pos
                    gled=0;
                    pos=right;
                    pc.printf("right\n");
                }

                if(x>0.9) {     //when x>0.9 go to up pos
                    rled=0;
                    pos=up;
                    pc.printf("up\n");
                }

                if(x<-0.9) {     //when x<-0.9 go to down pos
                    rled=0;
                    pos=down;
                    pc.printf("down\n");
                }

                break;

            case flat:          //when z<0.8 go bact to intermediate pos
                if(z<0.8) {       
                    bled=1;
                    pos=intermediate;
                }
                break;

            case over:          //when z>-0.8 go bact to intermediate pos
                if(z>-0.8) {
                    bled=1;
                    pos=intermediate;
                }
                break;

            case left:          //when y>-0.8 go bact to intermediate pos
                if(y>-0.8) {
                    gled=1;
                    pos=intermediate;
                }
                break;

            case right:       //when y<0.8 go bact to intermediate pos
                if(y<0.8) {
                    gled=1;
                    pos=intermediate;
                }
                break;

            case up:           //when x<0.8 go bact to intermediate pos
                if(x<0.8) {
                    rled=1;
                    pos=intermediate;
                }
                break;

            case down:    //when x>-0.8 go bact to intermediate pos
                if(x>-0.8) {
                    rled=1;
                    pos=intermediate;
                }
                break;
        }

        ThisThread::sleep_for(300);  // wait(0.3);

    }
}
