

#include "mbed.h"

InterruptIn button(PTD0);    //buttton function
AnalogIn ain(A0) ;          // Analog input
EventQueue queue;  // creates an event queue, to call read ADC

DigitalOut firstLED(D3);   // 1st lED
DigitalOut secondLED(D4);   // 2nd lED
DigitalOut thirdLED(D5);   // 3rd lED
DigitalOut fourthLED(D6);   // 4th lED
DigitalOut fifthLED(D7);   // 5th lED

Serial pc(USBTX, USBRX); // tx, rx, for debugging

// This thread runs the event queue
Thread eventThread ;

// Message type
typedef struct {
  uint16_t analog; /* Analog input value */
} message_t;

// Mail box
Mail<message_t, 2> mailbox;

// Function called every 10ms to read ADC
// Average using a low pass filter  
// Every 10th value is sent to mailbox
volatile int samples = 0 ;
volatile uint16_t smoothed = 0 ; 

volatile int pressEvent = 0 ;         //pressEvent as comunication flag 
void buttonCallback(){                //button call back function 
    pressEvent=!pressEvent;            
    }
    

void readA0() {
    smoothed = (smoothed >> 1) + (ain.read_u16() >> 1) ;
    samples++ ;
    if (samples == 10) {
        // send to thread
        message_t *mess = mailbox.alloc() ; // may fail but does not block
        if (mess) {
            mess->analog = smoothed ;
            mailbox.put(mess); // fails but does not block if full
        }
        samples = 0;
    }
}

// Write voltage digits
//   v  Voltage as scale int, e.g. 3.30 is 330
void vToString(int v, char* s) {    
    s[3] = '0' + (v % 10) ;
    v = v / 10 ;
    s[2] = '0' + (v % 10) ;
    v = v / 10 ;
    s[0] = '0' + (v % 10) ;
}

// Main program
//   Initialise variables
//   Attach ISR for ticker
//   Procss messages from mailbox    
int main() {


    int counter = 0 ;
    char vstring[] = "X.XX\r\n" ;
    firstLED=0;   // 1st lED
    secondLED=0;   // 2nd lED
    thirdLED=0;   // 3rd lED
    fourthLED=0;   // 4th lED
    fifthLED=0;    // 5th LED
    
    int volts=0;
    int MaxVolt =330;
    
    // Start the event queue
    eventThread.start(callback(&queue, &EventQueue::dispatch_forever));
    button.mode(PullUp);
    button.fall(&buttonCallback); 
    // call the readA0 function every 10ms 
    queue.call_every(10, readA0) ; 


    while (true) {
        osEvent evt = mailbox.get(); // wait for mail

        if (evt.status == osEventMail) {  
            message_t* mess = (message_t*)evt.value.p ;
            volts = (mess->analog * 330) / 0xffff ;
            if(pressEvent) {         //when button is pressed 
                MaxVolt=volts ;     // get the present value as the max voltage 
                pressEvent =0;      //set the button to up position 
            }
            mailbox.free (mess);


            if (volts==0) {
                firstLED=0;   // 1st lED
                secondLED=0;   // 2nd lED
                thirdLED=0;   // 3rd lED
                fourthLED=0;   // 4th lED
                fifthLED=0;    // 5th LED
            }

            if (volts>MaxVolt/6) {        //when voltage is bigger than 1/6 of the max volatge
                firstLED=1;
                secondLED=0;
                thirdLED=0;
                fourthLED=0;
                fifthLED=0;
            }

            if (volts>2*MaxVolt/6) {       //when voltage is bigger than 2/6 of the max volatge
                secondLED=1;
                thirdLED=0;
                fourthLED=0;
                fifthLED=0;
            }

            if (volts>3*MaxVolt/6) {     //when voltage is bigger than 3/6 of the max volatge
                thirdLED=1;
                fourthLED=0;
                fifthLED=0;
            }

            if (volts>4*MaxVolt/6) {   //when voltage is bigger than 4/6 of the max volatge
                fourthLED=1;
                fifthLED=0;
            }

            if (volts>5*MaxVolt/6) {    //when voltage is bigger than 5/6 of the max volatge
                fifthLED=1;
            } 
            vToString(volts, vstring) ;      // function to show the value on the computer
            counter++;
            if (counter==10) {
                pc.printf(vstring);
                counter=0;
            }

        }
    }
}

