//////////////////////////////
//Main Code for Themal Wake //
//Jonathan Zelaya           //
//April 11, 2019            //
//////////////////////////////

#define MULTIPLE_PROBES
#define ARM1_DATA_PIN p25
#define ARM2_DATA_PIN p19
#define TAIL_DATA_PIN p23
#define MAX_PROBES 25

#include "mbed.h"
#include "DS1820.h"
#include "ExtendedTimer.h"
#include "SDFileSystem.h"

DS1820* probe1[MAX_PROBES];
DS1820* probe2[MAX_PROBES];
DS1820* probeTail[MAX_PROBES];
SDFileSystem fs(p5, p6, p7, p8, "fs");
ExtendedTimer t;
Ticker sampleTime;
Ticker saveTime;
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
DigitalOut ledOn(p15);
DigitalOut ledError(p16);



int main(){
    int num_arm1 = 0;
    int num_arm2 = 0;
    int num_tail = 0;
    //mount filesystem
    bool mountFailure = fs.mount();//will let user know if SD mounting was successful
    if(mountFailure != 0){
        ledError = 1;
        return -1;//end program with error status
        }
        else
            ledOn = 1;
            
    unsigned long long fullName; //DS1820 is 64 bits( a long long)
    FILE* out1 = fopen("/fs/arm1.txt","a");//will create a different file for each sensor
    FILE* out2 = fopen("/fs/arm2.txt","a");
    FILE* out3 = fopen("/fs/tail.txt","a");
    
    //arm 1 set up
    while(DS1820::unassignedProbe(ARM1_DATA_PIN)){
        probe1[num_arm1] = new DS1820(ARM1_DATA_PIN);
        num_arm1++;
        if(num_arm1 == MAX_PROBES){
            break;
            }
        }
      
    //arm2 set up   
    while(DS1820::unassignedProbe(ARM2_DATA_PIN)){
        probe2[num_arm2] = new DS1820(ARM2_DATA_PIN);
        num_arm2++;
        if(num_arm2 == MAX_PROBES){
            break;
            }
        }
    
    //arm3 set up
    while(DS1820::unassignedProbe(TAIL_DATA_PIN)){
        probeTail[num_tail] = new DS1820(TAIL_DATA_PIN);
        num_tail++;
        if(num_tail == MAX_PROBES){
            break;
            }
        }
    
    //Writing headers for each file!
    fprintf(out1, "Found %d device(s)\r\n", num_arm1);//lets user know how many sensors were read during the actual flight
    fprintf(out2, "Found %d device(s)\r\n", num_arm2);
    fprintf(out3, "Found %d device(s)\r\n", num_tail);
    for(int i = 0; i < num_arm1; i++){//reads out the ID numbers to each file and numbers them
        fullName = probe1[i]->whoAmI();
        fprintf(out1, "\tID%d = ", i);
        fprintf(out1, "%llX\r\n", fullName);
        }
    for(int i = 0; i < num_arm2; i++){
        fullName = probe2[i]->whoAmI();
        fprintf(out2, "\tID%d = ", i);
        fprintf(out2, "%llX\r\n", fullName);
        }
    for(int i = 0; i < num_tail; i++){
        fullName = probeTail[i]->whoAmI();
        fprintf(out3, "\tID%d = ", i);
        fprintf(out3, "%llX\r\n", fullName);
        }
//Formatting of Data 

    fprintf(out1, "Sensors:    ");
    fprintf(out2, "Sensors:    ");    
    fprintf(out3, "Sensors:    ");    
    for(int i = 0; i < num_arm1; i++){
        fprintf(out1, "%d    ", i);
        }
    for(int i = 0; i < num_arm2; i++){
        fprintf(out2, "%d    ", i);
        }
    for(int i = 0; i < num_tail; i++){
        fprintf(out3, "%d    ", i);
        }   
    fprintf(out1, "\r\n");
    fprintf(out2, "\r\n");
    fprintf(out3, "\r\n");
        
//timer starts
    t.start();  
    
    while(t.read() < (60*60*4)){ //4 hours of data
            led1 = 1;
            probe1[0]-> convertTemperature(true, DS1820::all_devices);//convert all the temperature sensors
            probe2[0]-> convertTemperature(true, DS1820::all_devices);
            probeTail[0]-> convertTemperature(true, DS1820::all_devices); 
            led4 = 1;
        //print data from arm 1
            fprintf(out1, "%3.1f(s)    ", t.read());
            //get temp from sensors
            for(int i = 0; i < num_arm1; i++){
                fprintf(out1, "%3.1f ", probe1[i]->temperature());
                }
            fprintf(out1, "\r\n");    
                
            fprintf(out2, "%3.1f(s)    ", t.read());
            for(int i = 0; i < num_arm2; i++){
                fprintf(out2, "%3.1f ", probe2[i]->temperature());
                }
            fprintf(out2, "\r\n");    
            fprintf(out3, "%3.1f(s)    ", t.read());
            for(int i = 0; i < num_tail; i++){
                fprintf(out3, "%3.1f ", probeTail[i]->temperature());
                }
            fprintf(out3, "\r\n");    
                
        led3 = 1;
        fclose(out1);
        fclose(out2);
        fclose(out3);
        out1 = fopen("fs/arm1.txt","a");
        out2 = fopen("fs/arm2.txt","a");
        out3 = fopen("fs/armTail.txt","a");
        led3 = 0;
        wait(10);
    }
    
//close the file and unmount the file system 
    fclose(out1);
    fclose(out2);
    fclose(out3);
    fs.unmount();
    led2 = 1;//turn on LED to let user know its safe to remove SD card
    ledOn = 0;
    ledError = 1;
    }
