// hypark@kopo.ac.kr
// Core-1000 platform
#include "mbed.h"
#include "TextLCD.h"
#include "HCSR04.h"
#include "Dht11.h"
Serial pc(USBTX, USBRX);    // USART2 : PA2,PA3  
PwmOut servo(PB_13);        // SERVO PWM : PB13
PwmOut rled(PB_5);          // RED LED PWM : PB5
PwmOut dc_en(PB_1);         // DC PWM : PB1
DigitalOut dc_in1(PB_15);   // DC IN1 : PB15
DigitalOut dc_in2(PB_14);   // DC IN2 : PB14
DigitalOut buz(PC_4);       // define buzzer port
DigitalIn btn[4] = {PC_10,PC_11, PC_12, PA_13 };//스위치
AnalogIn analog_value(PC_1);    //ADC : PC1
Dht11 d_sen(PB_10);         //온습도 센서
HCSR04 u_sen(PC_7, PA_9);   // 초음파 센서 
TextLCD lcd(PC_6,PC_8,PC_5,PC_0,PA_12,PA_11,PB_12); 
void pc_send_data(uint8_t temp,uint8_t humi,float cds_value, float dist,uint8_t state)
{   static int count = 0;
    uint16_t test = 0;
    pc.putc(0xaa);          //STX
    pc.putc(0x55); 
    pc.putc(count++);       //COUNT
    pc.putc(temp);          //온도
    pc.putc(humi);          //습도
    test = (uint16_t)(cds_value * 4096.0f); 
    pc.putc((test >> 8) & 0x00ff); //CDS값 0 ~ 4095  
    pc.putc((test) & 0x00ff); 
    test = 0;
    test = btn[0]  | (btn[1] << 1) | (btn[2] << 2) | (btn[3] << 3);
    pc.putc((test) & 0x00ff);   //스위치
    pc.putc((uint8_t)(dist * 100.0f)); //초음파 
    pc.putc(state);         //상태값
    pc.putc(0xFE);          //ETX
}

int main() 
{   float dist = 0, cds_value = 0;
    int curr_temp = 0, curr_humi = 0;   //현재 온도 습도
    int goal_temp = 25, goal_humi = 30; //목표 온도 습도
    unsigned char state = 0;        //상태 저장 변수
    dc_in1 = 10; dc_in2 = 0;        //모터 회전 방향
    pc.baud(115200);                //통신 속도
    dc_en.period_ms(10);            //DC 모터 PWM 주기
    rled.period_ms(10);             //GREEN ED PWM 주기                         
    servo.period_ms(20);            //서보모터 PWM 주기
    while(1)     
    {   state = 0;                  //상태 변수 초기화
        //HC-SR04
        u_sen.startMeas();
        wait(0.1);
        u_sen.getMeas(dist);        
        if( dist < 0.2f)            //초음파 20CM 이내
        {   buz = 1;                //부저 울림
            state |= 0x01;
        }
        else    buz = 0;
        //ADC
        cds_value = analog_value.read();                         
        rled.pulsewidth_ms((int)(cds_value *3.0f));//CDS값 LED 반영 
        if(cds_value * 3.0f > 1.0f) state |= 0x40;  
        else                        state |= 0x80;
        //DHT11
        d_sen.read();                       //센서값 가져오기
        curr_temp = d_sen.getCelsius();     //섭씨 온도
        curr_humi = d_sen.getHumidity();    //습도
        lcd.gotoxy(1,2);                    //현재 온습도 출력
        lcd.printf("T%2dH%2d  CDS%.3f", curr_temp,curr_humi,cds_value); 
 //switch
        if(!btn[0]) goal_temp--;            //목표 온도 조정
        if(!btn[1]) goal_temp++;
        if(!btn[2]) goal_humi--;            //목표 습도 조정
        if(!btn[3]) goal_humi++;
        lcd.gotoxy(1,1);                    //목표 온습도 표시
        lcd.printf("SMARTFARM T%2dH%2d", goal_temp, goal_humi); 
        //servo
        if( curr_humi < goal_humi)          //현재습도가 목표보다 낮으면
        {   servo.pulsewidth_us(700);       //벨브(서보모터) -90도
            state |= 0x20;
        }else
        {   servo.pulsewidth_us(1500);      //벨브(서보모터) 0도
            state |= 0x10;
        }
        //dc motor 
        if( curr_temp > goal_temp + 5)       //목표온도보다 5도 높으면
        {   dc_en.pulsewidth_ms(10);         //팬(DC모터) 100% 구동
            state |= 0x02;
        }else if ( curr_temp > goal_temp)    //50% 구동
        {   dc_en.pulsewidth_ms(5); 
            state |= 0x04;
        }else
        {   dc_en.pulsewidth_ms(0);          // 정지
            state |= 0x08;
        }   
        wait(0.2);// delay 200 ms        
        pc_send_data(curr_temp, curr_humi, cds_value,dist, state);  // PC 데이터 전송    
     }
}

