#include "mbed.h"

Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut led01(LED1);

int i;          // for cycles
    char cmd_on[] = "on";
    char cmd_off[] = "off"; 
    
char *getCmd();
void processCmd(char *cmd);

Thread t1;

 ///////////////////////////////////////////////////////////////////////////////
void tSerial_body()
{
    while(1){ 
        if (pc.readable())     // if there is an character to read from the device
        {
            char *SerialCommand = getCmd();
            processCmd(SerialCommand);
            free(SerialCommand);
        }   
    }    
}
 ///////////////////////////////////////////////////////////////////////////////
char *getCmd()
{
    char buff[128];
    unsigned char ch;
    int buffIndex = 0;
    memset(buff, 0, sizeof(buff));          // clean the buffer


    char *cmd = (char*)malloc(128);
    if (!cmd)
        return NULL;
    do 
    {
        ch = pc.getc();   // read it
        if (buffIndex < 128){               // just to avoid buffer overflow
            buff[buffIndex] = ch;  // put it into the value array and increment the index
            buffIndex++;
        }
     }
     while (ch != '\n' && ch != '\r' );
     buff[buffIndex]='\0';  // add the end-signalling char
             
    if(strlen(buff) != 0){
        
        for (i = 0 ; i < sizeof(buff) ; i++){
            if (buff[i] == '\n' || buff[i] == '\r'){
                cmd[i] = '\0';
                return cmd;
            }
            cmd[i] = buff[i];                
        }
    }  
    return NULL;  
}
 ///////////////////////////////////////////////////////////////////////////////
void processCmd(char *cmd)
{
    pc.printf("rec: \"%s\"\n\r", cmd);
    if(strcmp(cmd,cmd_on) == 0){
        led01 = 1;
        pc.printf("Turning the led on.\n\r");
    } else if (strcmp(cmd,cmd_off) == 0) {
        led01 = 0;    
        pc.printf("Turning the led off.\n\r");
    
    }
}

///////////////////////////////////////////////////////////////////////////////
int main() 
{
    t1.start(tSerial_body);

    led01 = 1;
    
    pc.printf("\n\r App started______Banik pyco\n\r");
    int counter = 1;
    while(1)
    {   
        pc.printf("seconds: %d\n\r", counter++);
        wait(1);
    }
}