#include "mbed.h"
#include "rtos.h"
#include "stdio.h"
#include "stdlib.h"
#include "beep.h"
#include "WS2812.h"
#include "BufferedSoftSerial.h"
#include "pitches.h"

//PwmOut out(D9); //piezo buzzer
DigitalIn btn_enroll(D6);
DigitalIn btn_identify(D7);
DigitalIn btn_delete(D8);

Serial pc(USBTX, USBRX); //debug port
BufferedSoftSerial device(D2, D3);
Beep beep(D9);

float melody[] = {  NOTE_C7, NOTE_E7, NOTE_G7, NOTE_C8, NOTE_C8, NOTE_C8 };
float noteDuration[] = { 8.0, 8.0, 8.0, 4.0, 4.0, 8.0 };


void melodyStart();
void melodySuccess();
void melodyFail();
WS2812 ws(D11, 1, 7,15,10,15);
int colorbuf[4] = { 0x00000033, 0x0000FFFF, 0x0000FF00, 0x00001199}; //blue, orange, green, red

int main()
{
    
    melodyStart();

    //pc.baud(115200);
    device.baud(19200);
    unsigned char IS[] = { 0x40, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x51, 0x0A}; // Identify by Scan
    unsigned char ES[] = { 0x40, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x79, 0xBE, 0x0A}; // Enroll by Scan
    unsigned char DA[] = { 0x40, 0x17, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x0A}; // Delete all

    
    ws.useII(WS2812::GLOBAL);
    ws.setII(0xAA);

    melodyStart();

    while(1) {
        pc.printf("%d %d %d\n\r", btn_enroll, btn_identify, btn_delete);
        if(btn_enroll) {
            //ws.write(&colorbuf[3]);
            device.write((unsigned char*)ES, sizeof(ES));

            for(int i=0; i<2; i++) {
                ws.write(&colorbuf[0]);
                wait(0.2);

                while(1) {
                    if(device.readable() > 0)
                        break;
                }


                unsigned char rxBuffer[256]= {0};
                int count = 0;

                wait(0.2);

                while(device.readable()>0) {
                    rxBuffer[count] = (unsigned char)device.getc();
                    count++;
                }
                pc.printf("recv : ");
                for(int i=0; i<13; i++)
                    pc.printf("%d ", rxBuffer[i]);
                pc.printf("   count : %d \n\r", count);

                if((unsigned char)rxBuffer[10] == 0x62) {
                    while(1) {
                        if(device.readable()>0)
                            break;
                    }

                    int count = 0;

                    wait(0.2);

                    while(device.readable()) {
                        rxBuffer[count] = (unsigned char)device.getc();
                        count++;
                    }

                    unsigned int userID;
                    userID = rxBuffer[5] << 24 | rxBuffer[4] << 16 | rxBuffer[3] << 8 | rxBuffer[2];

                    pc.printf("userID : %d\n\r", userID);
                    if((unsigned char)rxBuffer[10] == 0x61) {
                        melodySuccess();
                    } else {
                        melodyFail();
                        break;
                    }
                } else {
                    melodyFail();
                    break;
                }
            }
        }
        if(btn_identify) {
            //ws.write(&colorbuf[3]);
            device.write((unsigned char*)IS, sizeof(IS));


            wait(0.2);

            while(1) {
                if(device.readable() > 0)
                    break;
            }


            unsigned char rxBuffer[256]= {0};
            int count = 0;

            wait(0.2);

            while(device.readable()>0) {
                rxBuffer[count] = (unsigned char)device.getc();
                count++;
            }
            pc.printf("recv : ");
            for(int i=0; i<13; i++)
                pc.printf("%d ", rxBuffer[i]);
            pc.printf("   count : %d \n\r", count);

            if((unsigned char)rxBuffer[10] == 0x62) {
                while(1) {
                    if(device.readable()>0)
                        break;
                }

                int count = 0;

                wait(0.2);

                while(device.readable()) {
                    rxBuffer[count] = (unsigned char)device.getc();
                    count++;
                }

                unsigned int userID;
                userID = rxBuffer[5] << 24 | rxBuffer[4] << 16 | rxBuffer[3] << 8 | rxBuffer[2];

                pc.printf("userID : %d\n\r", userID);
                if((unsigned char)rxBuffer[10] == 0x61) {
                    melodySuccess();
                } else {
                    melodyFail();

                }
            } else {
                melodyFail();

            }

        }
        if(btn_delete) {
            //ws.write(&colorbuf[3]);
            device.write((unsigned char*)DA, sizeof(DA));


            wait(0.2);

            while(1) {
                if(device.readable() > 0)
                    break;
            }


            unsigned char rxBuffer[256]= {0};
            int count = 0;

            wait(0.2);

            while(device.readable()>0) {
                rxBuffer[count] = (unsigned char)device.getc();
                count++;
            }
            pc.printf("recv : ");
            for(int i=0; i<13; i++)
                pc.printf("%d ", rxBuffer[i]);
            pc.printf("   count : %d \n\r", count);

            if((unsigned char)rxBuffer[10] == 0x61) {
                melodySuccess();
            } else {
                melodyFail();

            }
        }




        /*
        WS2812 ws(D11, 1, 7,15,10,15);
        beep.beep(4186.0, 1.0);
        wait(1.0);
        ws.write(&colorbuf[0]);
        wait(0.5);
        ws.write(&colorbuf[1]);
        wait(0.5);
        ws.write(&colorbuf[2]);
        wait(0.5);
        ws.write(&colorbuf[3]);
        wait(0.5);
        ws.write(&colorbuf[4]);
        wait(0.5);
        ws.write(&colorbuf[5]);
        wait(0.5);
        // if(sfm.writeable())


        device.write((unsigned char*)buff, 13);

        wait(5);
        */
        //ws.write(&colorbuf[0]);
        //wait(0.1);
    }

}

void melodyStart()
{
    beep.beep(melody[0], 1.0 / (float)noteDuration[0]);
    wait((1.0/(float)noteDuration[0])*1.30);
    beep.nobeep();

    beep.beep(melody[1], 1.0 / (float)noteDuration[1]);
    wait((1.0/(float)noteDuration[0])*1.30);
    beep.nobeep();

    beep.beep(melody[2], 1.0 / (float)noteDuration[2]);
    wait((1.0/(float)noteDuration[0])*1.30);
    beep.nobeep();

    beep.beep(melody[3], 1.0 / (float)noteDuration[3]);
    wait((1.0/(float)noteDuration[0])*1.30);
    beep.nobeep();
}

void melodySuccess()
{
    ws.write(&colorbuf[2]);
    
    beep.beep(melody[0], 1.0 / noteDuration[0]);
    wait((1.0/noteDuration[0])*1.30);
    beep.nobeep();

    beep.beep(melody[1], 1.0 / noteDuration[1]);
    wait((1.0/noteDuration[0])*1.30);
    beep.nobeep();

    beep.beep(melody[2], 1.0 / noteDuration[2]);
    wait((1.0/noteDuration[0])*1.30);
    beep.nobeep();
    ws.write(&colorbuf[0]);
}
void melodyFail()
{
    ws.write(&colorbuf[3]);
    beep.beep(melody[4], 1.0 / noteDuration[4]);
    wait((1.0/noteDuration[0])*1.30);
    beep.nobeep();

    beep.beep(melody[5], 1.0 / noteDuration[5]);
    wait((1.0/noteDuration[0])*1.30);
    beep.nobeep();
    ws.write(&colorbuf[0]);
}