//ESE519/ESE350 Lab5 Controller Part 1 (INCOMPLETE IMPLIMENTATION)
//Author: Chris Foley (Building on Carter Sharer original implementation)
//Date: 11/1/2019

#include "mbed.h"
#include <string>
#include "Joystick.h"
#include "wifiGETWrapper.h"
#define SEND        //Uncomment if you want to transmit data
#define NONE 250

//============================
//==    Pin Assignments     ==
//============================
//Knobs
#define POT1 p17  //Knob1
#define POT2 p18  //Knob2
#define POT3 p16  //Knob3
#define POT4 p15  //Knob4
//JoyStick
#define POTV p19 //Vertial
#define POTH p20 //Horizontal
//Button
#define BUTTON1 p21
#define COMMUNICATION_FORMAT "Jstickh:|%0.0f|Jstickv:|%0.0f|Knob1|%0.2f|Knob2|%0.2f|Knob3|%0.2f|Knob4|%0.2f|Button:|%d"

//============================
//==        Objects         ==
//============================
//Knobs
AnalogIn pot1(POT1);
AnalogIn pot2(POT2);
AnalogIn pot3(POT3);
AnalogIn pot4(POT4);
float knob1, knob2, knob3, knob4;

//Joystick
Joystick jstick(POTV, POTH);
float jstick_h, jstick_v;

//Button
DigitalIn Button(BUTTON1);
bool button;

// LEDs
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

// Timer
Timer timer;

// Serial port for showing RX data.
Serial pc(USBTX, USBRX);

char txBuffer[128];
char rxBuffer[128];
int rxLen;

int main (void)
{
    
    //Set Baud rate (9600-115200 is ideal)
    pc.baud(115200);
    pc.printf("\r\n Start! \r\n");

    //This is an example wifi connection! Please fill this in with the SSID of your BBBL and the password too.
    const char * SSID = "BeagleBone-365E";//TODO: CHANGE THIS LINE
    const char * password = "BeagleBone";//TODO: CHANGE THIS LINE

    initConnection(SSID,password);
    
    //Start Timer
    timer.start();

    //Scale Joystick Values, range[-100, 100]
    jstick.setScale(-100, 100);
    int counter = 0;
    while(1) {
        //(1) Read Joystick Values, round to int8_t presision
        jstick_h = (int8_t)jstick.horizontal();
        jstick_v = (int8_t)jstick.vertical();
        pc.printf("H: %0.2f V:%0.2f \r\n", jstick_h, jstick_v);

        //(2) Read Pot Values, Scale, and round to precision
        knob1 = (uint8_t)(pot1.read() * 100); //rounded to uint8_t
        knob2 = (pot2.read() * 100);
        knob3 = (pot3.read());
        knob4 = (int)(pot4.read() * 100);  //rounded to float

        //(3)Read Button Val, Add to buffer
        button = !Button.read(); //button is active low

#ifdef SEND    
        //SEND DATA: Send some data every 1/2 second
        if(timer.read_ms() >= 500) {
            //Reset the timer to 0
            timer.reset();
            // Toggle LED 2.
            led2 = led2^1;

            //(5) Add all values to buffer to be sent
            sprintf(txBuffer, COMMUNICATION_FORMAT, jstick_h, jstick_v, knob1, knob2, knob3, knob4, button);
    
            //(6) Send the buffer
            sendGET(txBuffer);
            pc.printf("Sent| %s\r\n", txBuffer);
        }   
#endif

    } //end loop
}//end main