#ifndef _COMMUNICATION_H_
#define _COMMUNICATION_H_

#include "mbed.h"
#include "rtos.h"
#include "MQTTNetwork.h"
#include "MQTTClient.h"
#include "MQTTmbed.h"
#include <string.h>
#include <queue>
#include <mutex>


typedef struct {
    char id;
    char speed; // speed for AccCar, -1 for Road
    char position; // position for AccCar, update number for Road
} message_t;

class Communication {
public:
    static EventFlags control_flags; // For cars waiting on speed control
    static EventFlags sync_flags;
    static int speeds[5];
    static int sync;
    static int flags[5];
    
    // Singleton
    static Communication *getInstance(char* t1, char* t2, char* t3, char* t4);
    
    // MQTT Setup
    void setup_wifi();
    void setup_mqtt(MQTTNetwork* network);
    static void message_arrived(MQTT::MessageData& md);
    static void control_arrived(MQTT::MessageData& md);
    static void sync_arrived(MQTT::MessageData& md);
    int send_message(char* topic);
    int subscribe_to_topic_control(char* topic);
    int subscribe_to_topic_sync(char* topic);
    void publish_car(int id, int speed, int position);
    void publish_road(int num);
    void start(); // function for serving requests (single thread)
    void reset(); // function to create and start the singleton thread
    void stop();
    
//private:
    static Communication *singleton;
    
    WiFiInterface *wifi;
    MQTTNetwork* network;
    MQTT::Client<MQTTNetwork, Countdown> *client;
    static Thread* thread;
    
    Mutex* mutex;
    std::queue<message_t>* q;
    
    char* topic_pub_position;
    char* topic_sub_control;
    char* topic_pub_receive;
    char* topic_sub_send;
    
    Communication(char* t1, char* t2, char* t3, char* t4);
    
};

#endif