#include "Road.h"

Serial pc_road(USBTX, USBRX);

Road::Road(Communication* c) {
    active_cars = 0x00;
    comm = c;
    n = 1;
}

void Road::add_car(Car* car) {
    // this->car1 = car;

    active_cars = active_cars | car->flag;
}

void Road::add_acc_car(AccCar* car, int id) {
    active_cars = active_cars | car->flag;

    switch(id) {
      case 1: {
        this->car1 = car;
        break;
      }
      case 2: {
        this->car2 = car;
        break;
      }
      case 3: {
        this->car3 = car;
        break;
      }
      case 4: {
        this->car4 = car;
        break;
      }
      case 5: {
        this->car5 = car;
        break;
      }
    }
}

void Road::let_cars_update() {
    go_flags.set(active_cars);
}

void Road::wait_for_car_update() {
    done_flags.wait_all(active_cars);
    comm->publish_road(n);
    Communication::sync_flags.wait_all(0x01);
    n = Communication::sync;
    pc_road.printf("Update number %d\r\n", n);
}
