#ifndef _ROAD_H_
#define _ROAD_H_

#include "mbed.h"
#include "Car.h"
#include "AccCar.h"
#include "Intersection.h"
#include "Communication.h"

class Car;
class AccCar;
class Intersection;

class Road {
public:
    EventFlags go_flags;
    EventFlags done_flags;
    Intersection *intersection;

    Road(Communication* c);
    void add_car(Car* car);
    void add_acc_car(AccCar* car, int id);
    void let_cars_update();
    void wait_for_car_update();
    
private:
    AccCar* car1;
    AccCar* car2;
    AccCar* car3;
    AccCar* car4;
    AccCar* car5;

    int active_cars;
    char* topic_send;
    char* topic_receive;
    Communication* comm;
    
    int n; // update number
};
#endif
