/** Temperature program to output to ULCD
 *
 * @author Alan Lai & Nelson Diaz
 * The Georgia Institute of Technology 
 * ECE 4180 Embeded Systems
 * Professor Hamblen
 * 03/28/2014
 * 
 * @section LICENSE
 * ----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE" (Revision 42):
 * <alanhlai91@gmail.com> wrote this file. As long as you retain this notice you
 * can do whatever you want with this stuff. If we meet some day, and you think
 * this stuff is worth it, you can buy me a beer in return.
 * ----------------------------------------------------------------------------
 *
 *
 * @section DESCRIPTION
 *
 * Honeywell HTU21D Humidity and Temperature sensor.
 *
 * Datasheet, specs, and information:
 *
 * https://www.sparkfun.com/products/12064
 */


#include "mbed.h"
#include "uLCD_4DGL.h"
#include "rtos.h"
#include "HTU21D.h"


Semaphore four_slots(1); //Activate semaphore

uLCD_4DGL uLCD(p28,p27,p29); // serial tx, serial rx, reset pin;
HTU21D temphumid(p9, p10); // Temp Module || sda, SCL
 
void sample_humidity(void const *args) { //line 2
    while(true){

        four_slots.wait();
        uLCD.color(0x0000FF);
        uLCD.locate(1,2); //col,row
        wait(0.1);
        uLCD.printf("Humidy Is: %d %%", temphumid.sample_humid());
        four_slots.release();
        Thread::wait(250);
    }
}


void sample_temperature(void const *args) { // line 4
    while(true){
    four_slots.wait();
    uLCD.color(0xFF0000);
    uLCD.locate(1,4); //col,row
    wait(0.1);
    uLCD.printf("Temp Is: %d° C", temphumid.sample_ctemp());
    uLCD.color(0xFFFF00);
    uLCD.locate(1,6);
    wait(0.1);
    uLCD.printf("Temp Is: %d° F", temphumid.sample_ftemp());
    uLCD.color(0xC0C0C0);
    uLCD.locate(1,8);
    wait(0.1);
    uLCD.printf("Temp Is: %d° k", temphumid.sample_ktemp());
    four_slots.release();
    Thread::wait(1000);
    }
}

 
int main() {
    uLCD.baudrate(3000000);
    Thread t1(sample_humidity);
    Thread t2(sample_temperature);
    while(1){ //While so program doesn't end
        
        }
}