#include "mbed.h"

BusOut bulb_hourL(p22,p23);
BusOut bulb_minR(p12,p11,p10,p9);
BusOut bulb_minL(p16,p15,p14,p13);
BusOut bulb_hourR(p20,p19,p18,p17);
DigitalIn switchTimeSet(p29);
DigitalIn switchAlarmSet(p27);
DigitalIn switchAlarmOn(p28);
DigitalIn buttonMinUp(p25);
DigitalIn buttonMinDown(p26);
DigitalIn buttonHourUp(p30);
DigitalIn buttonHourDown(p24);
PwmOut speaker(p21);


// Global alarm time
struct tm alarm;
struct tm* alarmTime = &alarm;



void setDigits(tm* clock) {
    uint8_t minR, minL, hour, hourR, hourL;
    hour = clock->tm_hour;
    minR = clock->tm_min % 10; // Right second digit
    minL = clock->tm_min / 10; // Left second digit
    if (hour == 24) {
        hour = 0;
    }
    
    
    hourR = hour % 10; // Right second digit
    hourL = hour / 10; // Left second digit
    
    // Set pins
    bulb_hourL = hourL;
    bulb_hourR = hourR;
    bulb_minL = minL;
    bulb_minR = minR;
    
    
    return;
}


void setAlarm() {
    while(switchAlarmSet) {
        setDigits(alarmTime);
        
        // Adjust time through buttons
        if (buttonMinUp)
            alarmTime->tm_min += 1;
        if (buttonMinDown)
            alarmTime->tm_min -= 1;
        if (buttonHourUp)
            alarmTime->tm_hour += 1;
        if (buttonHourDown)
            alarmTime->tm_hour -= 1;
        
        // If out of proper range, fix
        if (alarmTime->tm_min >= 60) {
            alarmTime->tm_min = 0;
            alarmTime->tm_hour += 1;
        }
        else if (alarmTime->tm_min < 0) {
            alarmTime->tm_min = 59;
            alarmTime->tm_hour -= 1;
        }
        if (alarmTime->tm_hour > 23) {
            alarmTime->tm_hour = 0;
        }
        if (alarmTime->tm_hour < 0) {
            alarmTime->tm_hour = 23;
        }
        wait(.1);
    }
    
    
    return;
}


void setTime() {
    struct tm* clock;
    time_t currTime = time(NULL);
    clock = localtime(&currTime);
    
    while(switchTimeSet) {
        setDigits(clock);
        
        // Adjust time through buttons
        if (buttonMinUp)
            clock->tm_min += 1;
        if (buttonMinDown)
            clock->tm_min -= 1;
        if (buttonHourUp)
            clock->tm_hour += 1;
        if (buttonHourDown)
            clock->tm_hour -= 1;
        
        // If out of proper range, fix
        if (clock->tm_min >= 60) {
            clock->tm_min = 0;
            clock->tm_hour += 1;
        }
        else if (clock->tm_min < 0) {
            clock->tm_min = 59;
            clock->tm_hour -= 1;
        }
        if (clock->tm_hour > 23) {
            clock->tm_hour = 0;
        }
        if (clock->tm_hour < 0) {
            clock->tm_hour = 23;
        }
        wait(.1);
    }
    
    // Set time
    time_t newTime = mktime(clock);
    set_time(newTime);
    
    return;
}


void wakeUp() {
    int i = 0;
    struct tm* clock;
    speaker.period(1.0/700.0);
    
    // Play tone until disabled or timeout
    while (switchAlarmOn && (i < 6000)){
        speaker = .5;
        i++;
        time_t currTime = time(NULL);
        clock = localtime(&currTime);
        setDigits(clock);
        
        // Alternate tone
        if (i%50 < 25)
            speaker.period(1.0/700.0);
        else
            speaker.period(1.0/500.0);
        
        // Snooze
        if (buttonMinUp || buttonMinDown || buttonHourUp || buttonHourDown) {
            speaker = 0;
            i = 0;
            for (int j = 0; j < 30000; j++) {
                time_t currTime = time(NULL);
                clock = localtime(&currTime);
                setDigits(clock);
                wait(.01);
            }
        }
        
        wait(.01);
    }
    
    speaker = 0;
    wait(2);
    return;
}

int main() {
    alarmTime->tm_hour = 12;
    struct tm* clock;
    
    while(1) {
        // Get current time
        time_t currTime = time(NULL);
        clock = localtime(&currTime);
        
        setDigits(clock);
        
        // Check if additional action needed
        if (switchAlarmSet)
            setAlarm();
        
        if (switchTimeSet)
            setTime();
        
        if (switchAlarmOn && clock->tm_hour == alarmTime->tm_hour && clock->tm_min == alarmTime->tm_min && clock->tm_sec == alarmTime->tm_sec)
            wakeUp();
        
        wait(.2);
    }
}
