#include "mbed.h"
#include "SDFileSystem.h"
#include "uLCD_4DGL.h"
#include "wave_player.h"
#include "stdio.h"

DigitalIn right(p13);
DigitalIn left(p11);
DigitalIn up(p15);
DigitalIn down(p12);

DigitalIn top(p17);
DigitalIn center(p20);
DigitalIn bottom(p19);
DigitalIn last(p16);

SDFileSystem sd(p5, p6, p7, p8, "sd");
uLCD_4DGL uLCD(p28,p27,p30);
//Analog Out Jack
AnalogOut DACout(p18);
//On Board Speaker
//PwmOut PWMout(p23);
wave_player waver(&DACout);
Timer t;

struct target {
        bool dead;
        int myX, myY;
        bool wasVisible;
};
float currScore;
float scores[9];


int main(void) {
    //Start timer for seed value
    t.start();
    uLCD.cls();
    uLCD.baudrate(3000000);
    bool newGame;
    int xloc, yloc, xold, yold, kills;
    target myTargets[10];
    
    
    for(int i = 0; i < 10; i++){
        scores[i] = 999.99;    
    }
    FILE *wfile;
    
    
    
    // Exit main menu on button press
    uLCD.media_init();
    uLCD.set_sector_address(0x003B, 0x5001);
    uLCD.display_image(0,0);
    
    wfile = fopen("/sd/intro.wav","r");
    waver.play(wfile);
    fclose(wfile);
    
    uLCD.locate(0,10);
    uLCD.printf("Button 1 to Start!");
    while(top){
        //reset high score list
        if(!last) {
            for(int i = 0; i < 10; i++){
                scores[i] = 999.99; 
                uLCD.locate(0,0);
                uLCD.printf("High scores reset");   
            }        
        } 
    }
    t.stop();
    
    
    
    //Main game loop
    while(true) {
    newGame = false;
    
    //Ready-set-go style countdown
    uLCD.cls();
    uLCD.locate(4,4);
    uLCD.printf("Get Ready!");
    wait(1); 
    uLCD.cls();
    uLCD.locate(8,4);
    uLCD.printf("3");
    wfile = fopen("/sd/beep.wav","r");
    waver.play(wfile);
    fclose(wfile);
    uLCD.cls();
    uLCD.locate(8,4);
    uLCD.printf("2");
    wfile = fopen("/sd/beep.wav","r");
    waver.play(wfile);
    fclose(wfile);
    uLCD.cls();
    uLCD.locate(8,4);
    uLCD.printf("1");
    wfile = fopen("/sd/beep.wav","r");
    waver.play(wfile);
    fclose(wfile);
    uLCD.cls();
    uLCD.locate(7,4);
    uLCD.printf("GO!");
    wfile = fopen("/sd/beephigh.wav","r");
    waver.play(wfile);
    fclose(wfile);
    uLCD.cls();
    
    
    xloc = 64;
    yloc = 64;
    xold = 0;
    yold = 0;
    kills = 0;
    
    
    //Create targets, use time as seed
    srand(t.read());
    
    for (int i = 0; i < 10; i++) {
        myTargets[i].myX = rand() % 128;
        myTargets[i].myY = rand() % 128;
        myTargets[i].dead = false;
        myTargets[i].wasVisible = false;
    }
    
    //Start score timer for game
    t.reset();
    t.start();
    while (!newGame) {
        //Redraw scope if moved
        if (xloc != xold || yloc != yold) {
            uLCD.filled_circle(xold, yold, 14, BLACK);
            uLCD.filled_circle(xloc, yloc, 14, GREEN);
            uLCD.filled_circle(xloc, yloc, 2, WHITE);
            xold = xloc;
            yold = yloc;
        }
        
        //Check if targets are visible
        for (int i = 0; i < 10; i++) {
            if (myTargets[i].dead == true) {
                continue;
            }
                
            if (abs(myTargets[i].myX - xloc) < 16 && abs(myTargets[i].myY - yloc) < 16) {
                uLCD.filled_circle(myTargets[i].myX, myTargets[i].myY, 10, RED);
                myTargets[i].wasVisible = true;
            }
            else if (myTargets[i].wasVisible == true) {
                myTargets[i].wasVisible = false;
                uLCD.filled_circle(myTargets[i].myX, myTargets[i].myY, 10, BLACK);
                uLCD.filled_circle(xloc, yloc, 14, GREEN);
                uLCD.filled_circle(xloc, yloc, 2, WHITE);
            }
        }
        
        
        //Check if shot hit
        if (!top) {
            wfile = fopen("/sd/newsilencer.wav","r");
            waver.play(wfile);
            fclose(wfile);
            for (int i = 0; i < 10; i++) {
                if (myTargets[i].dead == true)
                continue;
                if (abs(myTargets[i].myX - xloc) < 8 && abs(myTargets[i].myY - yloc) < 8) {
                    uLCD.filled_circle(myTargets[i].myX, myTargets[i].myY, 10, BLACK);
                    uLCD.filled_circle(xloc, yloc, 14, GREEN);
                    uLCD.filled_circle(xloc, yloc, 2, WHITE);
                    myTargets[i].dead = true;
                    kills++;
                    uLCD.filled_circle(xloc, yloc, 2, 0xffa500);//orange
                    
                
                   
            }
    }
        }  
                 
        if (!up) {
            yloc -= 6;
            if (yloc < 6)
                yloc = 6;
        }
        if (!down){
            yloc += 6;
            if (yloc > 121)
                yloc = 121;
        }
        if (!left) {
            xloc -= 6;
            if (xloc < 6)
                xloc = 6;
        }
        if (!right) {
            xloc += 6;
            if (xloc > 121)
                xloc = 121;
        }
        uLCD.locate(0,0);
        uLCD.printf("Time: %0.2f", t.read());
        wait(.025);
        //Win Screen
        if (kills >= 10) {
            t.stop();
            currScore = t.read() - .4;
            uLCD.cls();

            if(currScore < scores[0]){
                uLCD.locate(0,1);
                uLCD.printf("NEW HIGH SCORE!!!");    
            }
            for(int i = 0; i < 9; i++){ 
                if(currScore < scores[i]) {
                    for(int j = 7; j >= i; j--){
                     scores[j+1] = scores[j];
                    }  
                    scores[i] = currScore;
                    break;
                }
                    
            }
            
            uLCD.locate(0,3);
            uLCD.printf("High Scores\n");
            uLCD.printf("-----------\n");
            for(int i = 0; i < 9; i++){
                uLCD.printf("%d. %6.2f\n", i+1, scores[i]);    
            }
            //display score
            uLCD.locate(0,0);
            uLCD.printf("Final Score: %0.2f\n",currScore);
            wfile = fopen("/sd/youwinshort.wav","r");
            waver.play(wfile);
            fclose(wfile);
            uLCD.filled_rectangle(0, 0, 128, 16, BLACK);
            uLCD.locate(0,0);
            uLCD.printf("New Game?");
            while (true) {
                //Break and reset on button press
                if (!top) {
                    newGame = true;
                    break;
                }
               
            }
        }
    }
    }
}