#include "mbed.h"
#include "Pixy.h"
#include "PID_Control.h"
 
//------------------------------------
// Example for PIxy UART connection.
// Driver version 0.2
// BUGS::
// DO NOT USE PRINTF IN MAIN LOOP FOR PROPER OPERATION
// Pixy connected by UART (PA_9 and PA_10) with 460800 Baud
// Sample tries to center the recognised object between the pixy cam
//------------------------------------
 
//communication
Serial pc(USBTX, USBRX);
Serial cam(PA_9, PA_10);
 
DigitalOut myled(LED1);
 
//motor stuff
DigitalOut enableMotorDriver(PB_2);
PwmOut pwmL(PA_8);
PwmOut pwmR(PA_9);
 
Pixy pixy(cam);
 
int main()
{
    PID_Control pid;
 
    pid.setPIDValues( 0.01f, 0.0000f, 0.000000f, 0.3f, -0.3f, 1000);
 
    pc.baud( 115200 );
    pwmL.period(0.00005f); // Setzt die Periode auf 50 μs
    pwmR.period(0.00005f);
 
    //Wait untill pixy is ready
    wait( 2.0f);
 
    //enable motors
    enableMotorDriver = 1;
 
    //start while loop
    while(1) {
        wait( 0.005f );
        if( pixy.objectDetected() && pixy.getSignature() == 1) {
            float e = 160-pixy.getX();
            float diff = pid.calc( e, 0.005f );
            pwmL = 0.5f - diff;
            pwmR = 0.5f - diff;
        } else {
        pwmL = 0.5f ;
        pwmR = 0.5f;
        }
    }
}
