// blink.cpp - send a morse pattern to LED1
//
// Function morse() is one way for running LED1 with a blinking sequence using
// a busy wait, until the sequence is completed.
//
//    morse(" x xxx x    ");        send one time morse sequence, interval = 0.2
//    morse(" x xxx x    ",0.5);    send one time morse sequence, interval = 0.5
//    

#include "bricks/target.h"
#include "bricks/blink.h"

#ifndef LED_INVERTED
#   define LED_ON  1
#   define LED_OFF 0
#else
#   define LED_ON  0
#   define LED_OFF 1
#endif

   static DigitalOut led(LED1);         // LED1, being used for morse sequence

   void morse(const char *pattern, double interval)
   {
       for (; *pattern; pattern++)
       {
          led = (*pattern == ' ') ? LED_OFF : LED_ON;
          wait(interval);               // busy waiting for interval time
       }
   }
          
   