T02_SOS - Blinking LED according to Morse SOS pattern

This demo program runs a repeated SOS morse pattern on LED1. 
Helper function morse() is implemented as part of the bricks library (files
bricks/blink.cpp, bricks/blink.h and bricks/target.h.

We need a special header target.h with platformtarget specific definitions.
For example on a NUCLEO board LED1 needs to be assigned with a value of 1 for ON
and 0 for OFF. On a nRF51 board it is exactly the oposite. 

In order to achieve opposite behavour the header target.h defines conditionally
the define LED_INVERTED (only if nRF51 platform board is selected), which is
processed in blink.cpp to proper definitions for LED_ON and LED_OFF.

See blink.cpp:

#ifndef LED_INVERTED
#   define LED_ON  1
#   define LED_OFF 0
#else
#   define LED_ON  0
#   define LED_OFF 1
#endif

To make it running the libraries BLE_API and X_NUCLEO_IDB0XA1 have to be
updated (e.g. to be copied from a working NUCLEO BLE program).

Tested Boards:
   NUCLEO-L476RG, NUCLEO-F303K8, NUCLEO-F401RE
   nRF51-DK
   