// callback.cpp - deal with callbacks

#include "bricks/blob.h"
#include "bricks/callback.h"
#include "bricks/trace.h" 
   
//==============================================================================
// Setup Data Written Callback
//==============================================================================
   
   static void (*cbWritten)(O&o) = 0;       // where we have to follow up 

      // default onDataWritten callback

   static void dfWritten(const GattWriteCallbackParams *params)
   {
      O o;                                  // setup a blob
      o.pWritten = params;                  // store to provide access

      trace(o,2,"<data written>\n");

      if (cbWritten)
         (*cbWritten)(o);                   // user callback follow-up
   }


   void onWritten(O&o, void (*fptr)(O&o))   // setup data written callback
   {
      cbWritten = fptr;                     // remember function to follow-up
      o.gattServer().onDataWritten(dfWritten);// actual calback setup in GATT
   }

//==============================================================================
// Setup Connection Callback
//==============================================================================

   static void (*cbConnect)(Blob&) = 0;// where we have to follow up 

      // default connection callback
      
   static void dfConnect(const Gap::ConnectionCallbackParams_t *params)
   {
      O o;                                    // setup a blob object
      o.pConnect = params;                    // store to provide access
      
      trace(o,2,"<connect>\n");
      
      if (cbConnect)
         (*cbConnect)(o);                     // user callback follow-up
   }

   void onConnect(O&o,void(*fptr)(O&))        // setup connection callback
   {
      cbConnect = fptr;                       // remember function to follow-up
      o.gap().onConnection(dfConnect);        // actual callback setup in GAP
   }
   
//==============================================================================
// Setup Disconnection Callback
//==============================================================================

   static void (*cbDisconnect)(O&o) = 0;    // where we have to follow up 

      // default disconnection callback
      
   static void dfDisconnect(const Gap::DisconnectionCallbackParams_t *params)
   {
      Blob o;                               // setup a blob
      o.pDisconnect = params;               // store to provide access
      
      trace(o,2,"<disconnected>\n");

      if (cbDisconnect)
         (*cbDisconnect)(o);                // user callback follow-up
   }

   void onDisconnect(O&o,void(*fptr)(O&o))  // setup disconnection callback
   {
      cbDisconnect = fptr;                  // remember function to follow-up
      
      o.gap().onDisconnection(dfDisconnect);// actualcallback setup in GAP
   }
   
