// get.h - get data from a characteristics
//
// Synopsis:
//
//    Get data from a 'characteristic' into a 'data' variable
//
//       get(characteristic,data)
//
//    The 'get' function (overloaded function family) is implemented for all
//    types defined in "bricks/types.h".
//
//    See also: CHARACTERISTIC, SET
//
#ifndef _GET_H_
#define _GET_H_

#include "ble/BLE.h"
#include "ble/Gap.h"
#include "ble/GattClient.h"
#include "bricks/o.h"
#include "bricks/types.h"
#include "bricks/characteristic.h"

   inline void get(O&o, Characteristic<Bool> &chr, Bool &data)
   {
      uint16_t size = sizeof(Bool)/sizeof(uint8_t);
      o.gattServer().read(chr.getValueHandle(), (uint8_t*)&data,&size);
   }

   inline void get(O&o, Characteristic<Int> &chr, Int &data)
   {
      uint16_t size = sizeof(Int)/sizeof(uint8_t);
      o.gattServer().read(chr.getValueHandle(), (uint8_t*)&data,&size);
   }

   inline void get(O&o, Characteristic<ObjectId> &chr, ObjectId &data)
   {
      uint16_t size = sizeof(ObjectId)/sizeof(uint8_t);
      o.gattServer().read(chr.getValueHandle(), (uint8_t*)&data,&size);
   }

   inline void get(O&o, Characteristic<Buffer> &chr, Buffer &data)
   {
      uint16_t size = sizeof(Buffer)/sizeof(uint8_t);
      o.gattServer().read(chr.getValueHandle(), (uint8_t*)&data,&size);
   }

// we provide also some GET methods for GattCharacteristics. However the use
// of these methods are more dangerous, because a GattCharacteristics can be 
// of any type and the compiler cannot help us to check !!!

   inline void get(O&o,GattCharacteristic &chr, Bool &data)
   {
      uint16_t size = sizeof(Bool)/sizeof(uint8_t);
      o.gattServer().read(chr.getValueHandle(), (uint8_t*)&data, &size);
   }

#endif // _GET_H_