// blinker.h - blinking sequences for LED1
#ifndef _BLINKER_H_
#define _BLINKER_H_

#include <mbed.h>

#  define BLINKER_SEQUENCE_IDLE         "x       "
#  define BLINKER_SEQUENCE_ADVERTISE    "x xxx       "
#  define BLINKER_SEQUENCE_CONNECTED    "  xxx       "
#  define BLINKER_SEQUENCE_ACTION       "x x x x x       "
#  define BLINKER_SEQUENCE_ERROR        "x x x x xxx "
#  define BLINKER_SEQUENCE_TRANSITION   "x x x   "

   class Blinker
   {
      public:   // construction
         Blinker() {}                  // nothing to do
         
      public:
         void setled(bool state);
         void stop();
         void morse(const char *pattern, double periode = 0.2);
         void blink(const char *pattern, const char* next, double interval = 0.2);
         void blink(const char *pattern, double periode = 0.2);

         void idle(const char *action = BLINKER_SEQUENCE_IDLE)
         {
            blink(action,BLINKER_SEQUENCE_IDLE);
         }

         void advertise(const char *action = BLINKER_SEQUENCE_ADVERTISE)
         {
            blink(action,BLINKER_SEQUENCE_ADVERTISE);
         }
   
         void connected(const char *action = BLINKER_SEQUENCE_ACTION) 
         {
            blink(action, BLINKER_SEQUENCE_CONNECTED);  
         }

         void action()                 // 'action' blink sequence
         {
            blink(BLINKER_SEQUENCE_ACTION, BLINKER_SEQUENCE_IDLE);
         }

         void error(const char *action = BLINKER_SEQUENCE_ERROR)
         {
            blink(action,BLINKER_SEQUENCE_ERROR);
         }

         void on()                     // switch LED on
         {
             stop();  
             setled(true);
         }

         void off()                    // switch LED off
         {
             stop();  
             setled(false);
         }
   };
   
#endif // _BLINKER_H_