// xn6180.h - X-NUCLEO 6180XA1 expansion board functionality
//
// Example 1:
//
//    DisplayShield *pShield = new DisplayShield;
//    pShield->init("INIT",1000)                    // display "INIT" @ 1000 ms
//
#ifndef _XN6180_H_
#define _XN6180_H_

#include "x_nucleo_6180xa1.h"

#define InterruptTOF   range_continuous_interrupt   // just an alias
#define InterruptALS   als_continuous_interrupt     // just an alias
#define PollTOF        range_continuous_poll        // just an alias
#define PollALS        als_continuous_poll          // just an alias

   enum OpModeIntPoll_t { PollMeasure, IntMeasure };  // red slider position

   typedef OperatingMode OpMode;       // a short hand for Operating Mode
   
   class DisplayShield
   {
       public:
          DevI2C *pDevice;
          X_NUCLEO_6180XA1 *pBoard;
          MeasureData_t data;
          bool flagService;            // data read service request flag
       
       public:
          OperatingMode curMode;      // board's current operating mode
          OperatingMode prvMode;      // board's previous operating mode

       public:  // construction
          DisplayShield(const char *msg = 0, int msec = 1000);   // constructor
          void init(const char *msg = 0, int msec = 1000);  // initialize shield
          
       public:  // public methods
          void set();                  // set stop request
          void clear();                // clear stop request
          bool request();              // stop requested?
          void disable();              // disable interrupt
          void ready();                // set data ready status 
          int handle();                // handle IRQ
          int start(void (*pCb)(void));// start measurement
//        int start();                 // start measurement
          int stop();                  // stop current measurement

          void display(const char * msg);
          void display(const char * msg, int msec);  // display & wait
          void refresh(OpMode mode);
          void refresh();              // refresh display in current mode
          
       public:
          bool red();                  // red switch on or off?
          bool slider(enum OpModeIntPoll_t OpMode);  // did slider change?
          bool setup(OpMode mode);     // setup the operation mode

          void startMessage(OpMode mode);
          void startMessage();
          void stopMessage(OpMode mode);
          void stopMessage();
   };


#endif // _XN6180_H_