// set.h - set data from a characteristics
//
// Synopsis:
//
//    Set data from a 'characteristic' based on 'data' variable
//
//       set(characteristic,data)
//
//    The 'set' function (overloaded function family) is implemented for all
//    types defined in "bricks/types.h".
//
//    See also: CHARACTERISTIC, GET
//
#ifndef _SET_H_
#define _SET_H_

#include "ble/BLE.h"
#include "ble/Gap.h"
#include "ble/GattServer.h"
#include "bricks/o.h"
#include "bricks/types.h"
#include "bricks/characteristic.h"

   inline void set(O&o, Characteristic<Bool> &chr, const Bool &data)
   {
      uint16_t size = sizeof(Bool)/sizeof(uint8_t);
      o.gattServer().write(chr.getValueHandle(), (uint8_t*)&data,size);
   }

   inline void set(O&o, Characteristic<Int> &chr, const Int &data)
   {
      uint16_t size = sizeof(Int)/sizeof(uint8_t);
      o.gattServer().write(chr.getValueHandle(), (uint8_t*)&data,size);
   }

   inline void set(O&o, Characteristic<ObjectId> &chr, const ObjectId &data)
   {
      uint16_t size = sizeof(ObjectId)/sizeof(uint8_t);
      o.gattServer().write(chr.getValueHandle(), (uint8_t*)&data,size);
   }

// we provide also some SET methods for GattCharacteristics. However the use
// of these methods are more dangerous, because a GattCharacteristics can be 
// of any type and the compiler cannot help us to check !!!

   inline void set(O&o,GattCharacteristic &chr,Bool data)
   {
      uint16_t size = sizeof(Bool)/sizeof(uint8_t);
      o.gattServer().write(chr.getValueHandle(), (uint8_t*)&data,size);
   }

#endif // _SET_H_