// print.h - print value of a characteristic
//
// Synopsis:
//
//    See also: CHARACTERISTIC, GET, SET
//
#ifndef _PRINT_H_
#define _PRINT_H_

#include <stdio.h>
#include "ble/Gap.h"
#include "bricks/o.h"
#include "bricks/types.h"
#include "bricks/characteristic.h"

//==============================================================================
// Some Callbacks
//==============================================================================

   inline void print(O&o, Characteristic<Buffer> &chr, const char *name)
   {
      //Serial out(USBTX, USBRX);           // serial port to PC terminal
       
      Buffer data;  uint8_t *p = data;
      get(o,chr,data);

      printf("%s: %02x-%02x-%02x-%02x-%02x-",name,(int)(p[0]),(int)(p[1]),(int)(p[2]),(int)(p[3]),(int)(p[4]));
      printf("%02x-%02x-%02x-%02x-%02x\r\n",(int)(p[5]),(int)(p[6]),(int)(p[7]),(int)(p[8]),(int)(p[9]));
   }    

   inline void print(O&o, Characteristic<Bool> &chr, const char *name)
   {
      //Serial out(USBTX, USBRX);           // serial port to PC terminal
      Bool data;

      get(o,chr,data);
      printf("%s: %02x\r\n",name,data);
   }    

// we provide also some PRINT methods for non Characteristics. If the value of
// a characteristic needs to be printed the value must be fetched before with
// the GET function.

   inline void print(O&o, Bool data, const char *name)
   {
      printf("%s: %02x\r\n",name,(int)data);
   }    

#endif // _PRINT_H_