// S15_Blue_Button - GATT Detector setup with
//                   Blue Button connected to Presence characteristic

#include "bricks/bricks.h"

   Blinker blink;
   
//==============================================================================
// GATT Database Setup
//==============================================================================
   
// Detection Service

   Service detection(0xA010,"Detection"); // Detection Service
   Characteristic<Bool>        chrPresence(detection,0xA011, "n", "Presence"); 

// Debug Service

   Service debug(0xA030,"Debug");      // Debug Service
   Characteristic<Bool>        chrTest      (debug, 0xA031, "w", "Test"); 

   static void cbWritten(Blob &o)            // handle updates
   {
      Bool value;  
      
      if (updated(o,chrTest))          // has chrTest been updated?
      {
         get(o,chrTest,value);         // get value of chrTest
         set(o,chrPresence,value);     // and store this value to chrPresence 
      }
   }

   void services(O&o)
   {
      enroll(o,detection);             // enroll detection service
      enroll(o,debug);                 // enroll debug service
       
      onWritten(o,cbWritten);          // setup 'data written' callback
   }
   
//==============================================================================
// Button Functionality
//==============================================================================

   typedef enum state { OFF, ON, IDLE } State;
   
   State state = IDLE; 
   
   static void cbRise(void)
   {
      O o;                             // declare a blob (BLE OBject)
      Bool value = 0;  

      if (o.hasInitialized())
      {
         state = OFF;
         set(o,chrPresence,value);     // and store this value to chrPresence 
      }
   }

   static void cbFall(void)
   {
      O o;                             // declare a blob (BLE OBject)
      Bool value = 1;  

      if (o.hasInitialized())
      {
         state = ON;
         set(o,chrPresence,value);     // and store this value to chrPresence 
      }
   }
   
//==============================================================================
// Callbacks
//==============================================================================

   void cbError(O&o)                   // Error Reporting Callback
   {
       blink.error();                  // 'error' blink sequence
   }    

   void cbConnect(O&o)                 // Connection Callback
   {
      blink.connected();               // 'error' blink sequence
   }

   void cbDisconnect(O&o)              // Disconnection Callback
   {
      advertise(o);                    // start advertising on client disconnect
      blink.advertise();               // 'advertise' blink sequence
   }

   void cbSetup(O&o)                   // Immediately After Initializing BLE 
   {
      services(o);                     // enroll all services & setup callbacks

      onConnect(o,cbConnect);          // setup connection callback
      onDisconnect(o,cbDisconnect);    // setup disconnection callback
   
      device(o,"S15#2.0 Blue");        // setup device name
      name(o,"Detector");              // setup advertising name
      data(o,"My Layout");             // setup advertising data
         
      advertise(o,"C:ng",100);         // start advertising @ 100 msec interval
      blink.advertise();               // 'advertise' blink sequence
   }
   
//==============================================================================
// Main Program
//==============================================================================

   int main(void)
   {
      O o;                              // declare a blob (BLE OBject)
      verbose(o);                       // enable all trace messages
      blink.idle();                     // idle blinking - just started!

      InterruptIn button(USER_BUTTON);  // declare blue user button
      button.rise(&cbRise);             // interrupt callback setup
      button.fall(&cbFall);             // interrupt callback setup

      init(o,cbSetup,cbError);          // init BLE base layer, always do first
      
      while (true)                      // Infinite loop waiting for BLE events
      {
         sleep(o);                      // low power waiting for BLE events 
         
         if (state == ON)               // detection active ?
            blink.blink("xxx ");
            
         if (state == OFF)              // detection inactive ?
            blink.blink("x ");
            
         state = IDLE;                  // reset to IDLE state
      }
   }