// stop.cpp - stop button functionality

#include "bricks/stop.h"

//==============================================================================
// Stop Button Functionality
//==============================================================================

   static bool flag;                   // stop indication flag

   static void cbButton(void)          // button press callback
   {
      flag = true;
   } 
          
   void StopButton::set()              // set stop flag
   {
      flag = true;
   }
   
   void StopButton::clear()            // clear stop flag
   {
      flag = false;
   }
   
   bool StopButton::request()          // stop requested?
   {
      return flag;
   }
          
   StopButton::StopButton(PinName pin) : InterruptIn(pin)   // constructor
   {
      clear();
      rise(&cbButton);  
   }

// eof