// S14_TOF_Detector - Easy GATT setup using bricks for DETECTION services

#include "bricks/bricks.h"
#include "detection.h"
#include "bricks/stop.h"
#include "shields/shields.h"

   typedef DisplayShield Dish;         // a short hand for DisplayShield

   Dish *pShield;                      // to access our 6180XA1 DIsplay SHield
   StopButton  stop(USER_BUTTON);      // press blue button for stop

//==============================================================================
// Data Ready Callback
//==============================================================================

   static void cbReady(void)           // called if measurement done, data ready
   {
       pShield->ready();               // forward IRQ callback to ready()
   }

//==============================================================================
// Simple Loop - Cannot Change Mode
//==============================================================================

   void loop(Dish &o)
   {
      int err = o.start(cbReady);      // start measuement callback @ cbReady

      if (err == 0)
      {
//       while ( !stop.request() )
         {
            if( o.request() )          // data service requested by 6180XA1 IRQ?
               o.handle();             // handle data transfer

            o.refresh();               // refresh display
         }
         o.stop();                     // stop all current measurements
      }
//    stop.clear();                    // clear stop request (of stop button)
   }    


//==============================================================================
// Callbacks
//==============================================================================

   void cbError(O&o)                   // Error Reporting Callback
   {
       blinkError(o);                  // 'error' blink sequence
   }    

   void cbConnect(O&o)                 // Connection Callback
   {
      blinkConnected(o);               // 'error' blink sequence
   }

   void cbDisconnect(O&o)              // Disconnection Callback
   {
      advertise(o);                    // start advertising on client disconnect
      blinkAdvertise(o);               // 'advertise' blink sequence
   }

   void cbSetup(O&o)                   // Immediately After Initializing BLE 
   {
      services(o);                     // enroll all services & setup callbacks

      onConnect(o,cbConnect);          // setup connection callback
      onDisconnect(o,cbDisconnect);    // setup disconnection callback
   
      device(o,"S14#0.15 ToF Detector"); // setup device name
      name(o,"Detector");              // setup advertising name
      data(o,"My Layout");             // setup advertising data
         
      advertise(o,"C:ng",100);         // start advertising @ 100 msec interval
      blinkAdvertise(o);               // 'advertise' blink sequence
   }
   
//==============================================================================
// Main Program
//==============================================================================

#define VL6180X_I2C_SDA   D14 
#define VL6180X_I2C_SCL   D15 

#define RANGE   0
#define ALS     1

   int main(void)
   {
      O o;                             // declare a blob (BLE OBject)
      verbose(o);                      // enable all trace messages
      blinkIdle(o);                    // idle blinking - just started!

      //pShield = new Dish;            // create a DIsplay SHield class instance
      //pShield->init("ToF",1000);


      DevI2C *pDevice;
      X_NUCLEO_6180XA1 *pBoard;

      pDevice = new DevI2C(VL6180X_I2C_SDA, VL6180X_I2C_SCL);     
      
         // next we create the 6180XA1 expansion board singleton obj 
         // after that we are already able to display the init message
      
      //pBoard = X_NUCLEO_6180XA1::Instance(pDevice, A3, A2, D13, D2);

      init(o,cbSetup,cbError);         // init BLE base layer, always do first
      sleep(o,5000);
      
      pBoard = X_NUCLEO_6180XA1::Instance(pDevice, A3, A2, D13, D2);

      while (true)                     // Infinite loop waiting for BLE events
         sleep(o);                     // low power waiting for BLE events 
   }